/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.lib;

import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class LazyIngredient {
    public static final LazyIngredient EMPTY = new LazyIngredient(null, null, null){

        @Override
        public Ingredient getIngredient() {
            return Ingredient.EMPTY;
        }
    };
    private final String id;
    private final DataComponentMap components;
    private final Type type;
    private Ingredient ingredient;

    private LazyIngredient(String id, Type type, DataComponentMap components) {
        this.id = id;
        this.type = type;
        this.components = components;
    }

    public static LazyIngredient item(String name) {
        return LazyIngredient.item(name, DataComponentMap.EMPTY);
    }

    public static LazyIngredient item(String name, DataComponentMap components) {
        return new LazyIngredient(name, Type.ITEM, components);
    }

    public static LazyIngredient tag(String name) {
        return new LazyIngredient(name, Type.TAG, DataComponentMap.EMPTY);
    }

    public String getId() {
        return this.id;
    }

    public boolean isItem() {
        return this.type == Type.ITEM;
    }

    public boolean isTag() {
        return this.type == Type.TAG;
    }

    public Ingredient getIngredient() {
        if (this.ingredient == null) {
            Item item;
            if (this.isTag()) {
                TagKey tag = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)this.id));
                this.ingredient = Ingredient.of((TagKey)tag);
            } else if (this.isItem() && (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.id))) != Items.AIR) {
                if (this.components == null || this.components.isEmpty()) {
                    this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
                } else {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    stack.applyComponents(this.components);
                    this.ingredient = DataComponentIngredient.of((boolean)false, (ItemStack)stack);
                }
            }
        }
        return this.ingredient == null ? Ingredient.EMPTY : this.ingredient;
    }

    private static enum Type {
        ITEM,
        TAG;

    }
}

