/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.client.render;

import appeng.api.client.AEKeyRenderHandler;
import appeng.client.gui.style.Blitter;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class FluxKeyRenderHandler
implements AEKeyRenderHandler<FluxKey> {
    public static final FluxKeyRenderHandler INSTANCE = new FluxKeyRenderHandler();

    private FluxKeyRenderHandler() {
    }

    public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, FluxKey stack) {
        EnergyType type = stack.getEnergyType();
        Blitter.sprite((TextureAtlasSprite)((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(type.getIcon()))).blending(false).dest(x, y, 16, 16).blit(guiGraphics);
    }

    public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, FluxKey what, float scale, int combinedLight, Level level) {
        EnergyType type = what.getEnergyType();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(type.getIcon());
        int color = 0xFFFFFF;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.01f);
        VertexConsumer buffer = buffers.getBuffer(RenderType.solid());
        float x0 = -(scale -= 0.05f) / 2.0f;
        float y0 = scale / 2.0f;
        float x1 = scale / 2.0f;
        float y1 = -scale / 2.0f;
        Matrix4f transform = poseStack.last().pose();
        buffer.addVertex(transform, x0, y1, 0.0f).setColor(color).setUv(sprite.getU0(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x1, y1, 0.0f).setColor(color).setUv(sprite.getU1(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x1, y0, 0.0f).setColor(color).setUv(sprite.getU1(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x0, y0, 0.0f).setColor(color).setUv(sprite.getU0(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        poseStack.popPose();
    }

    public Component getDisplayName(FluxKey stack) {
        return stack.getDisplayName();
    }
}

