/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Position;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiText
extends GuiElement<GuiText>
implements ForegroundRender {
    private Supplier<Component> text;
    private Supplier<Boolean> shadow = () -> true;
    private Supplier<Integer> textColour = () -> -1;
    private Supplier<Double> rotation = null;
    private Position rotatePoint = Position.create(() -> this.xSize() / 2.0, () -> this.ySize() / 2.0);
    private boolean trim = false;
    private boolean wrap = false;
    private boolean scroll = true;
    private Align alignment = Align.CENTER;

    public GuiText(@NotNull GuiParent<?> parent) {
        this(parent, () -> null);
    }

    public GuiText(@NotNull GuiParent<?> parent, @Nullable Component text) {
        this(parent, () -> text);
    }

    public GuiText(@NotNull GuiParent<?> parent, @NotNull Supplier<@Nullable Component> text) {
        super(parent);
        this.text = text;
    }

    public GuiText autoHeight() {
        this.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> {
            double d;
            if (this.wrap) {
                d = this.font().wordWrapHeight((FormattedText)this.getText(), (int)this.xSize());
            } else {
                Objects.requireNonNull(this.font());
                d = 9.0;
            }
            return d;
        }));
        return this;
    }

    public GuiText setTextSupplier(@NotNull Supplier<@Nullable Component> textSupplier) {
        this.text = textSupplier;
        return this;
    }

    public GuiText setText(@Nullable Component text) {
        this.text = () -> text;
        return this;
    }

    public GuiText setText(@NotNull String text) {
        this.text = () -> Component.literal((String)text);
        return this;
    }

    public GuiText setTranslatable(@NotNull String translationKey) {
        this.text = () -> Component.translatable((String)translationKey);
        return this;
    }

    @Nullable
    public Component getText() {
        return this.text.get();
    }

    public GuiText setAlignment(Align alignment) {
        this.alignment = alignment;
        return this;
    }

    public Align getAlignment() {
        return this.alignment;
    }

    public GuiText setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.scroll = false;
            this.wrap = false;
        }
        return this;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public GuiText setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.scroll = false;
            this.trim = false;
        }
        return this;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public GuiText setScroll(boolean scroll) {
        this.scroll = scroll;
        if (scroll) {
            this.wrap = false;
            this.trim = false;
        }
        return this;
    }

    public boolean getScroll() {
        return this.scroll;
    }

    public GuiText setShadow(@NotNull Supplier<Boolean> shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiText setShadow(boolean shadow) {
        this.shadow = () -> shadow;
        return this;
    }

    public boolean getShadow() {
        return this.shadow.get();
    }

    public GuiText setTextColour(Supplier<Integer> textColour) {
        this.textColour = textColour;
        return this;
    }

    public GuiText setTextColour(int textColour) {
        this.textColour = () -> textColour;
        return this;
    }

    public int getTextColour() {
        return this.textColour.get();
    }

    public GuiText setRotation(double rotation) {
        return this.setRotation(() -> rotation);
    }

    public GuiText setRotation(@Nullable Supplier<Double> rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiText setRotatePoint(Position rotatePoint) {
        this.rotatePoint = rotatePoint;
        return this;
    }

    @Override
    public double getForegroundDepth() {
        return 0.05;
    }

    @Override
    public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        Component component = this.getText();
        if (component == null) {
            return;
        }
        Font font = render.font();
        Objects.requireNonNull(font);
        int textHeight = 9;
        int textWidth = font.width((FormattedText)component);
        boolean tooLong = (double)textWidth > this.xSize();
        double yPos = this.yMin() + this.ySize() / 2.0 - (double)textHeight / 2.0 + 1.0;
        PoseStack stack = render.pose();
        if (this.rotation != null) {
            stack.pushPose();
            stack.translate(this.xMin() + this.rotatePoint.x(), this.yMin() + this.rotatePoint.y(), 0.0);
            stack.mulPose(Axis.ZP.rotationDegrees(this.rotation.get().floatValue()));
            stack.translate(-this.xMin() - this.rotatePoint.x(), -this.yMin() - this.rotatePoint.y(), 0.0);
        }
        if (tooLong && this.getTrim()) {
            MutableComponent tail = Component.literal((String)"...").setStyle(this.getText().getStyle());
            FormattedText head = font.getSplitter().headByWidth((FormattedText)component, (int)this.xSize() - font.width((FormattedText)tail), this.getText().getStyle());
            FormattedCharSequence formatted = Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{head, tail}));
            textWidth = font.width(formatted);
            double xPos = this.alignment == Align.MIN ? this.xMin() : (this.alignment == Align.MAX ? this.xMax() - (double)textWidth : this.xMin() + this.xSize() / 2.0 - (double)textWidth / 2.0);
            render.drawString(formatted, xPos, yPos, this.getTextColour(), this.getShadow());
        } else if ((tooLong || this.font().split((FormattedText)component, Integer.MAX_VALUE).size() > 1) && this.wrap) {
            textHeight = font.wordWrapHeight((FormattedText)component, (int)this.xSize());
            List list = font.split((FormattedText)component, (int)this.xSize());
            yPos = this.yMin() + this.ySize() / 2.0 - (double)textHeight / 2.0;
            for (FormattedCharSequence line : list) {
                int lineWidth = font.width(line);
                double xPos = this.alignment == Align.MIN ? this.xMin() : (this.alignment == Align.MAX ? this.xMax() - (double)lineWidth : this.xMin() + this.xSize() / 2.0 - (double)lineWidth / 2.0);
                render.drawString(line, xPos, yPos, this.getTextColour(), this.getShadow());
                Objects.requireNonNull(font);
                yPos += 9.0;
            }
        } else if (tooLong && this.scroll) {
            render.pushScissorRect(this.getRectangle());
            render.drawScrollingString(component, this.xMin(), yPos, this.xMax(), this.getTextColour(), this.getShadow(), false);
            render.popScissor();
        } else {
            double xPos = this.alignment == Align.MIN ? this.xMin() : (this.alignment == Align.MAX ? this.xMax() - (double)textWidth : this.xMin() + this.xSize() / 2.0 - (double)textWidth / 2.0);
            render.drawString(component, xPos, yPos, this.getTextColour(), this.getShadow());
        }
        if (this.rotation != null) {
            stack.popPose();
        }
    }
}

