/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.sugar.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.lib.apache.commons.tuple.Pair;
import nolijium.mixinextras.service.MixinExtrasService;
import nolijium.mixinextras.sugar.Cancellable;
import nolijium.mixinextras.sugar.Local;
import nolijium.mixinextras.sugar.Share;
import nolijium.mixinextras.sugar.impl.CancellableSugarApplicator;
import nolijium.mixinextras.sugar.impl.LocalSugarApplicator;
import nolijium.mixinextras.sugar.impl.ShareSugarApplicator;
import nolijium.mixinextras.sugar.impl.SugarParameter;
import nolijium.mixinextras.utils.ASMUtils;
import nolijium.mixinextras.utils.CompatibilityHelper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

abstract class SugarApplicator {
    private static final Map MAP = new HashMap();
    protected final IMixinInfo mixin;
    protected final InjectionInfo info;
    protected final AnnotationNode sugar;
    protected final Type paramType;
    protected final Type paramGeneric;
    protected final int paramLvtIndex;
    protected final int paramIndex;

    SugarApplicator(InjectionInfo injectionInfo, SugarParameter sugarParameter) {
        this.mixin = CompatibilityHelper.getMixin(injectionInfo).getMixin();
        this.info = injectionInfo;
        this.sugar = sugarParameter.sugar;
        this.paramType = sugarParameter.type;
        this.paramGeneric = sugarParameter.genericType;
        this.paramLvtIndex = sugarParameter.lvtIndex;
        this.paramIndex = sugarParameter.paramIndex;
    }

    abstract void validate(Target var1, InjectionNodes.InjectionNode var2);

    abstract void prepare(Target var1, InjectionNodes.InjectionNode var2);

    abstract void inject(Target var1, InjectionNodes.InjectionNode var2, StackExtension var3);

    int postProcessingPriority() {
        throw new UnsupportedOperationException(String.format("Sugar type %s does not support post-processing! Please inform LlamaLad7!", ASMUtils.annotationToString(this.sugar)));
    }

    static SugarApplicator create(InjectionInfo injectionInfo, SugarParameter sugarParameter) {
        try {
            return (SugarApplicator)((Class)MAP.get(sugarParameter.sugar.desc)).getDeclaredConstructor(InjectionInfo.class, SugarParameter.class).newInstance(injectionInfo, sugarParameter);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    static boolean isSugar(String string) {
        return MAP.containsKey(string);
    }

    static {
        for (Pair pair : Arrays.asList(Pair.of(Cancellable.class, CancellableSugarApplicator.class), Pair.of(Local.class, LocalSugarApplicator.class), Pair.of(Share.class, ShareSugarApplicator.class))) {
            for (String string : MixinExtrasService.getInstance().getAllClassNames(((Class)pair.getLeft()).getName())) {
                MAP.put("L" + string.replace('.', '/') + ';', (Class)pair.getRight());
            }
        }
    }
}

