/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.injector;

import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.lib.apache.commons.ArrayUtils;
import nolijium.mixinextras.utils.ASMUtils;
import nolijium.mixinextras.utils.CompatibilityHelper;
import nolijium.mixinextras.utils.InjectorUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class WrapWithConditionInjector
extends Injector {
    public WrapWithConditionInjector(InjectionInfo injectionInfo) {
        super(injectionInfo, "@WrapWithCondition");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode injectionNode) {
        this.checkTargetIsLogicallyVoid(target, injectionNode);
        this.checkTargetModifiers(target, false);
        this.wrapTargetWithCondition(target, injectionNode);
    }

    private void checkTargetIsLogicallyVoid(Target target, InjectionNodes.InjectionNode injectionNode) {
        if (injectionNode.hasDecoration("mixinextras_operationIsImmediatelyPopped")) {
            return;
        }
        if ((injectionNode = this.getReturnType(injectionNode.getCurrentTarget())) == null) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
        }
        if (injectionNode != Type.VOID_TYPE) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an instruction with a non-void return type in %s in %s", new Object[]{this.annotationType, target, this}));
        }
    }

    private void wrapTargetWithCondition(Target target, InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
        Type type = this.getReturnType(abstractInsnNode);
        Type[] typeArray = this.getEffectiveArgTypes(injectionNode.getOriginalTarget());
        Type[] typeArray2 = this.getEffectiveArgTypes(abstractInsnNode);
        InsnList insnList = new InsnList();
        InsnList insnList2 = new InsnList();
        boolean bl = InjectorUtils.isVirtualRedirect(injectionNode);
        this.invokeHandler(target, type, typeArray, typeArray2, bl, insnList, insnList2);
        AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
        target.wrapNode(abstractInsnNode2, abstractInsnNode2, insnList, insnList2);
    }

    private void invokeHandler(Target target, Type type, Type[] object, Type[] typeArray, boolean bl, InsnList insnList, InsnList insnList2) {
        Injector.InjectorData injectorData = new Injector.InjectorData(target, "condition wrapper");
        this.validateParams(injectorData, Type.BOOLEAN_TYPE, (Type[])object);
        object = new StackExtension(target);
        int[] nArray = this.storeArgs(target, typeArray, insnList, 0);
        int[] nArray2 = ArrayUtils.addAll(nArray, target.getArgIndices());
        if (bl) {
            nArray2 = ArrayUtils.remove(nArray2, 0);
        }
        ((StackExtension)object).receiver(this.isStatic);
        ((StackExtension)object).capturedArgs(target.arguments, injectorData.captureTargetArgs);
        ((StackExtension)object).extra(1);
        WrapWithConditionInjector wrapWithConditionInjector = this;
        wrapWithConditionInjector.invokeHandlerWithArgs(wrapWithConditionInjector.methodArgs, insnList, nArray2);
        target = new LabelNode();
        object = new LabelNode();
        insnList.add((AbstractInsnNode)new JumpInsnNode(153, (LabelNode)target));
        this.pushArgs(typeArray, insnList, nArray, 0, nArray.length);
        insnList2.add((AbstractInsnNode)new JumpInsnNode(167, (LabelNode)object));
        insnList2.add((AbstractInsnNode)target);
        if (type != Type.VOID_TYPE) {
            insnList2.add((AbstractInsnNode)new InsnNode(ASMUtils.getDummyOpcodeForType(type)));
        }
        insnList2.add((AbstractInsnNode)object);
    }

    private Type getReturnType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode instanceof MethodInsnNode) {
            return Type.getReturnType((String)((MethodInsnNode)abstractInsnNode).desc);
        }
        if (abstractInsnNode instanceof FieldInsnNode) {
            if ((abstractInsnNode = (FieldInsnNode)abstractInsnNode).getOpcode() == 180 || abstractInsnNode.getOpcode() == 178) {
                return Type.getType((String)abstractInsnNode.desc);
            }
            return Type.VOID_TYPE;
        }
        return null;
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (abstractInsnNode.getOpcode() == 184) {
                return Type.getArgumentTypes((String)methodInsnNode.desc);
            }
            return (Type[])ArrayUtils.addAll(new Type[]{Type.getObjectType((String)methodInsnNode.owner)}, Type.getArgumentTypes((String)methodInsnNode.desc));
        }
        if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            if (fieldInsnNode.getOpcode() == 181) {
                return new Type[]{Type.getObjectType((String)fieldInsnNode.owner), Type.getType((String)fieldInsnNode.desc)};
            }
            if (fieldInsnNode.getOpcode() == 179) {
                return new Type[]{Type.getType((String)fieldInsnNode.desc)};
            }
        }
        throw new UnsupportedOperationException();
    }
}

