/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.injector;

import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.utils.ASMUtils;
import nolijium.mixinextras.utils.CompatibilityHelper;
import nolijium.mixinextras.utils.InjectorUtils;
import nolijium.mixinextras.utils.MixinExtrasLogger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class ModifyExpressionValueInjector
extends Injector {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("ModifyExpressionValue");

    public ModifyExpressionValueInjector(InjectionInfo injectionInfo) {
        super(injectionInfo, "@ModifyExpressionValue");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode injectionNode) {
        this.checkTargetReturnsAValue(target, injectionNode);
        this.checkTargetModifiers(target, false);
        StackExtension stackExtension = new StackExtension(target);
        AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
        Type type = this.getReturnType(abstractInsnNode);
        boolean bl = false;
        if (abstractInsnNode instanceof TypeInsnNode && abstractInsnNode.getOpcode() == 187) {
            if (!InjectorUtils.isDupedNew(injectionNode)) {
                target.insns.insert(abstractInsnNode, (AbstractInsnNode)new InsnNode(89));
                stackExtension.extra(1);
                injectionNode.decorate("mixinextras_newIsDuped", (Object)Boolean.TRUE);
                bl = true;
            }
            abstractInsnNode = ASMUtils.findInitNodeFor(target, (TypeInsnNode)abstractInsnNode);
        }
        this.injectValueModifier(target, abstractInsnNode, type, InjectorUtils.isDupedFactoryRedirect(injectionNode), bl, stackExtension);
    }

    private void checkTargetReturnsAValue(Target target, InjectionNodes.InjectionNode injectionNode) {
        if ((injectionNode = this.getReturnType(injectionNode.getCurrentTarget())) == Type.VOID_TYPE) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an instruction with a return type of 'void' in %s in %s", new Object[]{this.annotationType, target, this}));
        }
        if (injectionNode == null) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
        }
    }

    private void injectValueModifier(Target target, AbstractInsnNode abstractInsnNode, Type type, boolean bl, boolean bl2, StackExtension stackExtension) {
        InsnList insnList = new InsnList();
        this.invokeHandler(type, target, insnList, stackExtension);
        if (bl2) {
            insnList.add((AbstractInsnNode)new InsnNode(87));
        }
        target.insns.insert(this.getInsertionPoint(abstractInsnNode, target, bl), insnList);
    }

    private void invokeHandler(Type type, Target target, InsnList insnList, StackExtension stackExtension) {
        Injector.InjectorData injectorData = new Injector.InjectorData(target, "expression value modifier");
        this.validateParams(injectorData, type, new Type[]{type});
        if (!this.isStatic) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (type.getSize() == 2) {
                stackExtension.extra(1);
                insnList.add((AbstractInsnNode)new InsnNode(91));
                insnList.add((AbstractInsnNode)new InsnNode(87));
            } else {
                insnList.add((AbstractInsnNode)new InsnNode(95));
            }
        }
        if (injectorData.captureTargetArgs > 0) {
            this.pushArgs(target.arguments, insnList, target.getArgIndices(), 0, injectorData.captureTargetArgs);
        }
        stackExtension.receiver(this.isStatic);
        stackExtension.capturedArgs(target.arguments, injectorData.captureTargetArgs);
        this.invokeHandler(insnList);
    }

    private AbstractInsnNode getInsertionPoint(AbstractInsnNode object, Target target, boolean bl) {
        if (!bl) {
            return object;
        }
        if ((target = InjectorUtils.findFactoryRedirectThrowString(target, (AbstractInsnNode)object)) == null) {
            return object;
        }
        object = () -> ModifyExpressionValueInjector.lambda$getInsertionPoint$0((String)((LdcInsnNode)target).cst, (AbstractInsnNode)object);
        if ((target = target.getNext()).getOpcode() != 183) {
            return (AbstractInsnNode)object.get();
        }
        if ((target = target.getNext()).getOpcode() != 191) {
            return (AbstractInsnNode)object.get();
        }
        if (!((target = target.getNext()) instanceof LabelNode)) {
            return (AbstractInsnNode)object.get();
        }
        return target;
    }

    private Type getReturnType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode instanceof MethodInsnNode) {
            return Type.getReturnType((String)((MethodInsnNode)abstractInsnNode).desc);
        }
        if (abstractInsnNode instanceof FieldInsnNode) {
            if ((abstractInsnNode = (FieldInsnNode)abstractInsnNode).getOpcode() == 180 || abstractInsnNode.getOpcode() == 178) {
                return Type.getType((String)abstractInsnNode.desc);
            }
            return Type.VOID_TYPE;
        }
        if (Bytecode.isConstant((AbstractInsnNode)abstractInsnNode)) {
            return Bytecode.getConstantType((AbstractInsnNode)abstractInsnNode);
        }
        if (abstractInsnNode instanceof TypeInsnNode && abstractInsnNode.getOpcode() == 187) {
            return Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
        }
        return null;
    }

    private static /* synthetic */ AbstractInsnNode lambda$getInsertionPoint$0(String string, AbstractInsnNode abstractInsnNode) {
        LOGGER.warn("Please inform LlamaLad7! Failed to find end of factory redirect throw for '{}'", string);
        return abstractInsnNode;
    }
}

