/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.blocks.matrix;

import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.blocks.matrix.BlockAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixFrame;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockAssemblerMatrixFrame
extends BlockAssemblerMatrixBase<TileAssemblerMatrixFrame> {
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);

    public BlockAssemblerMatrixFrame() {
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)Shape.block)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SHAPE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getShapeType(this.defaultBlockState(), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        return this.getShapeType(state, level, pos);
    }

    @Override
    public Item getPresentItem() {
        return EAESingletons.ASSEMBLER_MATRIX_FRAME.asItem();
    }

    private BlockState getShapeType(BlockState baseState, LevelAccessor level, BlockPos pos) {
        boolean zz;
        int z;
        int y;
        Shape type = Shape.block;
        int x = pos.getX();
        boolean xx = BlockAssemblerMatrixFrame.isFrame(level, x - 1, y = pos.getY(), z = pos.getZ()) && BlockAssemblerMatrixFrame.isFrame(level, x + 1, y, z);
        boolean yy = BlockAssemblerMatrixFrame.isFrame(level, x, y - 1, z) && BlockAssemblerMatrixFrame.isFrame(level, x, y + 1, z);
        boolean bl = zz = BlockAssemblerMatrixFrame.isFrame(level, x, y, z - 1) && BlockAssemblerMatrixFrame.isFrame(level, x, y, z + 1);
        if (xx && !yy && !zz) {
            type = Shape.column_x;
        } else if (!xx && yy && !zz) {
            type = Shape.column_y;
        } else if (!xx && !yy && zz) {
            type = Shape.column_z;
        }
        return (BlockState)baseState.setValue(SHAPE, (Comparable)((Object)type));
    }

    private static boolean isFrame(LevelAccessor level, int x, int y, int z) {
        return level.getBlockState(new BlockPos(x, y, z)).is((Block)EAESingletons.ASSEMBLER_MATRIX_FRAME);
    }

    public static enum Shape implements StringRepresentable
    {
        block,
        column_x,
        column_y,
        column_z;


        @NotNull
        public String getSerializedName() {
            return this.name();
        }
    }
}

