/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui.pattern;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.items.misc.WrappedGenericStack;
import com.glodblock.github.extendedae.container.pattern.ContainerPattern;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class GuiPattern<T extends ContainerPattern>
extends AbstractContainerScreen<T> {
    private int cycle = 0;
    private int cycleTick = 0;

    public GuiPattern(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
        ((ContainerPattern)this.menu).setCycleItem(this.cycle);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int x, int y) {
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        ContainerPattern.DisplayOnlySlot dpSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof ContainerPattern.DisplayOnlySlot && !(dpSlot = (ContainerPattern.DisplayOnlySlot)slot).getItem().isEmpty()) {
            long amount;
            AEItemKey key;
            ItemStack stack = dpSlot.getItem();
            Item item = dpSlot.getItem().getItem();
            if (item instanceof WrappedGenericStack) {
                WrappedGenericStack wgs = (WrappedGenericStack)item;
                v0 = wgs.unwrapWhat(stack);
            } else {
                v0 = key = AEItemKey.of((ItemStack)stack);
            }
            if (item instanceof WrappedGenericStack) {
                WrappedGenericStack wgs = (WrappedGenericStack)item;
                v1 = wgs.unwrapAmount(stack);
            } else {
                v1 = amount = dpSlot.getActualAmount();
            }
            if (key != null && amount > 0L) {
                List currentToolTip = AEKeyRendering.getTooltip((AEKey)key);
                if (Tooltips.shouldShowAmountTooltip((AEKey)key, (long)amount)) {
                    currentToolTip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.StoredAmount, (AEKey)key, (long)amount));
                }
                if (key instanceof AEItemKey) {
                    guiGraphics.renderTooltip(this.font, currentToolTip, stack.getTooltipImage(), stack, x, y);
                } else {
                    guiGraphics.renderComponentTooltip(this.font, currentToolTip, x, y);
                }
            }
            return;
        }
        super.renderTooltip(guiGraphics, x, y);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.cycleTick % 80 == 0) {
            ++this.cycle;
            ((ContainerPattern)this.menu).setCycleItem(this.cycle);
        }
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.hoveredSlot != null) {
            guiGraphics.hLine(this.leftPos + this.hoveredSlot.x, this.leftPos + this.hoveredSlot.x + 16, this.topPos + this.hoveredSlot.y - 1, -2424833);
            guiGraphics.hLine(this.leftPos + this.hoveredSlot.x - 1, this.leftPos + this.hoveredSlot.x + 16, this.topPos + this.hoveredSlot.y + 16, -2424833);
            guiGraphics.vLine(this.leftPos + this.hoveredSlot.x - 1, this.topPos + this.hoveredSlot.y - 2, this.topPos + this.hoveredSlot.y + 16, -2424833);
            guiGraphics.vLine(this.leftPos + this.hoveredSlot.x + 16, this.topPos + this.hoveredSlot.y - 2, this.topPos + this.hoveredSlot.y + 16, -2424833);
            GuiPattern.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(this.leftPos + this.hoveredSlot.x), (int)(this.topPos + this.hoveredSlot.y), (int)0, (int)1721553919);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ++this.cycleTick;
    }
}

