/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.TerminalStyle;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ILinkStatus;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.core.network.serverbound.QuickMovePatternPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.api.PatternSearchMode;
import com.glodblock.github.extendedae.client.button.EPPIcon;
import com.glodblock.github.extendedae.client.button.HighlightButton;
import com.glodblock.github.extendedae.client.button.HighlightButtonSmall;
import com.glodblock.github.extendedae.container.ContainerExPatternTerminal;
import com.glodblock.github.extendedae.util.MessageUtil;
import com.google.common.collect.HashMultimap;
import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.document.LytRect;
import guideme.render.SimpleRenderContext;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiExPatternTerminal<T extends ContainerExPatternTerminal>
extends AEBaseScreen<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiExPatternTerminal.class);
    private static final int GUI_WIDTH = 195;
    private static final int MAGIC_NUMBER = 0;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 30;
    private static final int GUI_FOOTER_HEIGHT = 99;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 30);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 30, 195, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 66, 195, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 102, 195, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 48, 195, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 84, 195, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 120, 195, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 138, 195, 99);
    private static final Rect2i HIGHLIGHT_BBOX = new Rect2i(0, 237, 18, 18);
    private static final Comparator<PatternContainerGroup> GROUP_COMPARATOR = Comparator.comparing(group -> group.name().getString().toLowerCase(Locale.ROOT));
    private final HashMap<Long, PatternContainerRecord> byId = new HashMap();
    private final HashMap<Integer, HighlightButton> highlightBtns = new HashMap();
    private final HashMap<Long, PatternProviderInfo> infoMap = new HashMap();
    private final HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup = HashMultimap.create();
    private final ArrayList<PatternContainerGroup> groups = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Set<ItemStack> matchedStack = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<ItemStack>(this){

        public int hashCode(ItemStack o) {
            return ItemStack.hashItemAndComponents((ItemStack)o);
        }

        public boolean equals(ItemStack a, ItemStack b) {
            return a == b || a != null && b != null && ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
        }
    });
    private final Set<PatternContainerRecord> matchedProvider = new HashSet<PatternContainerRecord>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.BIG);
    private final AETextField searchField;
    private final SearchButton searchMode;
    protected int visibleRows = 0;
    private final ServerSettingToggleButton<ShowPatternProviders> showPatternProviders;

    public GuiExPatternTerminal(T menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.imageWidth = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar((Button)this.showPatternProviders);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setResponder(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        this.searchField.setTooltipMessage(Collections.singletonList(Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.04")));
        this.searchMode = new SearchButton(this::changeSearchMode);
    }

    private void changeSearchMode(Button btn) {
        SearchButton modeBtn = (SearchButton)btn;
        modeBtn.nextMode();
        this.refreshList();
        switch (modeBtn.mode) {
            case IN: {
                this.searchField.setTooltipMessage(Collections.singletonList(Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.02")));
                break;
            }
            case OUT: {
                this.searchField.setTooltipMessage(Collections.singletonList(Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.01")));
                break;
            }
            case IN_OUT: {
                this.searchField.setTooltipMessage(Collections.singletonList(Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.04")));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected search mode: " + String.valueOf((Object)modeBtn.mode));
            }
        }
    }

    public void init() {
        this.visibleRows = this.config.getTerminalStyle().getRows((this.height - 30 - 99 - 54 + 0) / 18);
        if (this.visibleRows < 2) {
            this.visibleRows = 2;
        }
        this.imageHeight = 129 + this.visibleRows * 18;
        super.init();
        this.setInitialFocus((GuiEventListener)this.searchField);
        this.highlightBtns.forEach((k, v) -> {
            v.setVisibility(false);
            this.addRenderableWidget((GuiEventListener)v);
        });
        this.searchMode.setPosition(this.leftPos + 73, this.topPos + 17);
        this.addRenderableWidget((GuiEventListener)this.searchMode);
        this.resetScrollbar();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((ContainerExPatternTerminal)this.menu).slots.removeIf(slot -> slot instanceof PatternSlot);
        this.highlightBtns.forEach((key, value) -> value.setVisibility(false));
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int i = 0;
        while (true) {
            block10: {
                int rows;
                PatternContainerGroup group;
                int slots;
                int offset;
                PatternContainerRecord container;
                if (i >= this.visibleRows) {
                    this.renderLinkStatus(guiGraphics, ((ContainerExPatternTerminal)this.getMenu()).getLinkStatus());
                    return;
                }
                if (scrollLevel + i >= this.rows.size()) break block10;
                Row row = this.rows.get(scrollLevel + i);
                if (this.highlightBtns.containsKey(scrollLevel + i)) {
                    HighlightButton btn = this.highlightBtns.get(scrollLevel + i);
                    btn.setPosition(this.leftPos + 8 + 162 - 1, this.topPos + (i + 1) * 18 + 12);
                    btn.setVisibility(true);
                }
                if (row instanceof SlotsRow) {
                    int n;
                    PatternContainerRecord patternContainerRecord;
                    SlotsRow slotsRow = (SlotsRow)row;
                    container = patternContainerRecord = slotsRow.container();
                    offset = n = slotsRow.offset();
                    slots = n = slotsRow.slots();
                }
                if (!(row instanceof GroupHeaderRow)) break block10;
                GroupHeaderRow groupHeaderRow = (GroupHeaderRow)row;
                try {
                    PatternContainerGroup col222;
                    group = col222 = groupHeaderRow.group();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (group.icon() != null) {
                    SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
                    renderContext.renderItem(group.icon().toStack(), 10, 36 + i * 18, 8.0f, 8.0f);
                }
                Object displayName = (rows = this.byGroup.get((Object)group).size()) > 1 ? Component.empty().append(group.name()).append((Component)Component.literal((String)(" (" + rows + ")"))) : group.name();
                FormattedCharSequence text = Language.getInstance().getVisualOrder(this.font.substrByWidth((FormattedText)displayName, 145));
                guiGraphics.drawString(this.font, text, 20, 36 + i * 18, textColor, false);
                break block10;
                for (int col222 = 0; col222 < slots; ++col222) {
                    PatternSlot slot2 = new PatternSlot(container, offset + col222, col222 * 18 + 8, (i + 1) * 18 + 13);
                    ((ContainerExPatternTerminal)this.menu).slots.add((Object)slot2);
                    if (this.searchField.getValue().isEmpty()) continue;
                    if (this.matchedStack.contains(slot2.getItem())) {
                        this.blit(guiGraphics, slot2.x - 1, slot2.y - 1, HIGHLIGHT_BBOX);
                        continue;
                    }
                    if (this.matchedProvider.contains(container)) continue;
                    this.fillRect(guiGraphics, new Rect2i(slot2.x, slot2.y, 16, 16), 0x6A000000);
                }
            }
            ++i;
        }
    }

    private void renderLinkStatus(GuiGraphics guiGraphics, ILinkStatus linkStatus) {
        if (!linkStatus.connected()) {
            SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
            LytRect rect = new LytRect(7, 30, 162, this.visibleRows * 18);
            renderContext.fillRect(rect, (ColorValue)new ConstantColor(0x3F000000));
            Component statusDescription = linkStatus.statusDescription();
            if (statusDescription != null) {
                renderContext.renderTextCenteredIn(statusDescription.getString(), ERROR_TEXT_STYLE, rect);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        block3: {
            Row row;
            int hoveredLineIndex;
            if (this.hoveredSlot == null && (hoveredLineIndex = this.getHoveredLineIndex(x, y)) != -1 && (row = this.rows.get(hoveredLineIndex)) instanceof GroupHeaderRow) {
                PatternContainerGroup group;
                GroupHeaderRow groupHeaderRow = (GroupHeaderRow)row;
                try {
                    PatternContainerGroup patternContainerGroup;
                    group = patternContainerGroup = groupHeaderRow.group();
                    if (group.tooltip().isEmpty()) break block3;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                guiGraphics.renderTooltip(this.font, group.tooltip(), Optional.empty(), x, y);
                return;
            }
        }
        super.renderTooltip(guiGraphics, x, y);
    }

    private int getHoveredLineIndex(int x, int y) {
        x = x - this.leftPos - 8;
        y = y - this.topPos - 30;
        if (x < 0 || y < 0) {
            return -1;
        }
        if (x >= 162 || y >= this.visibleRows * 18) {
            return -1;
        }
        int rowIndex = this.scrollbar.getCurrentScroll() + y / 18;
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return -1;
        }
        return rowIndex;
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.isMouseOver(xCoord, yCoord)) {
            this.searchField.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void slotClicked(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternSlot) {
            PatternSlot machineSlot = (PatternSlot)slot;
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().getAbilities().instabuild) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getSlotIndex(), machineSlot.getMachineInv().getServerId());
                PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return;
        }
        if (clickType == ClickType.QUICK_MOVE && ((ContainerExPatternTerminal)this.menu).isPlayerSideSlot(slot)) {
            LinkedHashSet<Long> visiblePatternContainers = new LinkedHashSet<Long>();
            for (Row row : this.rows) {
                if (!(row instanceof SlotsRow)) continue;
                SlotsRow slotsRow = (SlotsRow)row;
                visiblePatternContainers.add(slotsRow.container.getServerId());
            }
            int clickedSlot = slot.getContainerSlot();
            QuickMovePatternPacket packet = new QuickMovePatternPacket(((ContainerExPatternTerminal)this.menu).containerId, clickedSlot, List.copyOf(visiblePatternContainers));
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        super.slotClicked(slot, slotIdx, mouseButton, clickType);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blit(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 30;
        this.blit(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            Rect2i bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blit(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.setWidth(8 + 18 * slotsRow.slots - 1);
                this.blit(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean charTyped(char character, int key) {
        if (character == ' ' && this.searchField.getValue().isEmpty() && this.searchField.isFocused()) {
            return true;
        }
        return super.charTyped(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.infoMap.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postTileInfo(long id, BlockPos pos, ResourceKey<Level> dim, Direction face) {
        this.infoMap.put(id, new PatternProviderInfo(pos, face, dim));
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, PatternContainerGroup group, int inventorySize, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = new PatternContainerRecord(inventoryId, inventorySize, sortBy, group);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            LOGGER.warn("Ignoring incremental update for unknown inventory id {}", (Object)inventoryId);
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.showPatternProviders.set((Enum)((ContainerExPatternTerminal)this.menu).getShownProviders());
    }

    private void refreshList() {
        this.byGroup.clear();
        this.highlightBtns.forEach((k, v) -> this.removeWidget((GuiEventListener)v));
        this.highlightBtns.clear();
        this.matchedStack.clear();
        this.matchedProvider.clear();
        String filter = this.searchField.getValue().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(filter + ":_:" + String.valueOf((Object)this.searchMode.mode));
        boolean rebuild = cachedSearch.isEmpty();
        boolean searchOutput = this.searchMode.mode.isOut();
        boolean searchInput = this.searchMode.mode.isIn();
        for (PatternContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = filter.isEmpty();
            if (!found) {
                for (ItemStack itemStack : entry.getInventory()) {
                    boolean midRes = searchOutput ? this.itemStackMatchesSearchTerm(itemStack, filter, true) : false;
                    if (searchInput && !midRes) {
                        midRes = this.itemStackMatchesSearchTerm(itemStack, filter, false);
                    }
                    if (!midRes) continue;
                    found = true;
                }
            }
            if (found || entry.getSearchName().contains(filter)) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                if (!entry.getSearchName().contains(filter)) continue;
                this.matchedProvider.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.groups.sort(GROUP_COMPARATOR);
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        for (PatternContainerGroup group : this.groups) {
            this.rows.add(new GroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                PatternProviderInfo info;
                AppEngInternalInventory inventory = container.getInventory();
                if (inventory.size() > 0 && (info = this.infoMap.get(container.getServerId())) != null) {
                    HighlightButtonSmall btn = new HighlightButtonSmall();
                    btn.setMultiplier(this.playerToBlockDis(info.pos()));
                    btn.setTarget(info.pos, info.face, info.world);
                    btn.setSuccessJob(() -> {
                        if (this.getPlayer() != null && info.pos != null && info.world != null) {
                            Component message = MessageUtil.createEnhancedHighlightMessage((Player)this.getPlayer(), info.pos, info.world, "chat.ex_pattern_access_terminal.pos");
                            this.getPlayer().displayClientMessage(message, false);
                        }
                    });
                    btn.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.tooltip.03")));
                    btn.setVisibility(false);
                    this.highlightBtns.put(this.rows.size(), (HighlightButton)this.addRenderableWidget((GuiEventListener)btn));
                }
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    SlotsRow containerRow = new SlotsRow(container, offset, slots);
                    this.rows.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    private double playerToBlockDis(BlockPos pos) {
        if (pos == null) {
            return 0.0;
        }
        BlockPos ps = this.getPlayer().getOnPos();
        return pos.distSqr((Vec3i)ps);
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, boolean checkOut) {
        if (itemStack.isEmpty()) {
            return false;
        }
        IPatternDetails result = null;
        if (itemStack.getItem() instanceof EncodedPatternItem) {
            result = PatternDetailsHelper.decodePattern((ItemStack)itemStack, (Level)((ContainerExPatternTerminal)this.menu).getPlayer().level());
        }
        if (result == null) {
            return false;
        }
        List<GenericStack> list = checkOut ? result.getOutputs() : Arrays.stream(result.getInputs()).map(i -> i.getPossibleInputs()[0]).toList();
        for (GenericStack item : list) {
            String displayName;
            if (item == null || !(displayName = item.what().getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.children().removeAll(this.renderables);
        this.renderables.clear();
        this.init();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.groups.size() + this.byId.size();
    }

    private void blit(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/ex_pattern_access_terminal.png");
        guiGraphics.blit(texture, offsetX, offsetY, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight());
    }

    public static class SearchButton
    extends IconButton {
        private PatternSearchMode mode = PatternSearchMode.IN_OUT;
        private static final int length = PatternSearchMode.values().length;

        public SearchButton(Button.OnPress onPress) {
            super(onPress);
            this.width = 12;
            this.height = 12;
        }

        protected Icon getIcon() {
            return null;
        }

        protected void nextMode() {
            this.mode = PatternSearchMode.values()[(this.mode.ordinal() + 1) % length];
        }

        protected Blitter getBlitter() {
            switch (this.mode) {
                case IN: {
                    return EPPIcon.SEARCH_INPUT;
                }
                case OUT: {
                    return EPPIcon.SEARCH_OUTPUT;
                }
                case IN_OUT: {
                    return EPPIcon.SEARCH_IO;
                }
            }
            throw new IllegalStateException("Unexpected search mode: " + String.valueOf((Object)this.mode));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
            if (this.visible) {
                int yOffset;
                Blitter blitter = this.getBlitter();
                int n = yOffset = this.isHovered() ? 1 : 0;
                Blitter bgIcon = this.isHovered() ? EPPIcon.TERMINAL_BUTTON_HOVER : (this.isFocused() ? EPPIcon.TERMINAL_BUTTON_FOCUS : EPPIcon.TERMINAL_BUTTON);
                bgIcon.dest(this.getX(), this.getY() + yOffset, 12, 12).zOffset(2).blit(guiGraphics);
                blitter.dest(this.getX(), this.getY() + yOffset).zOffset(3).blit(guiGraphics);
            }
        }

        public Rect2i getTooltipArea() {
            return new Rect2i(this.getX(), this.getY(), 12, 12);
        }

        public List<Component> getTooltipMessage() {
            MutableComponent cmp = switch (this.mode) {
                default -> throw new MatchException(null, null);
                case PatternSearchMode.IN -> Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.search_mode.02");
                case PatternSearchMode.OUT -> Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.search_mode.01");
                case PatternSearchMode.IN_OUT -> Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.search_mode.03");
            };
            return List.of(Component.translatable((String)"gui.extendedae.ex_pattern_access_terminal.search_mode"), cmp.withStyle(ChatFormatting.GRAY));
        }
    }

    static sealed interface Row
    permits GroupHeaderRow, SlotsRow {
    }

    record SlotsRow(PatternContainerRecord container, int offset, int slots) implements Row
    {
    }

    record GroupHeaderRow(PatternContainerGroup group) implements Row
    {
    }

    public record PatternProviderInfo(@Nullable BlockPos pos, @Nullable Direction face, @Nullable ResourceKey<Level> world) {
    }
}

