/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.tooltip;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.swedz.tesseract.neoforge.tooltip.TooltipHandler;

public final class TooltipAttachment
implements Comparable<TooltipAttachment> {
    private final TooltipFunction function;
    private boolean requiresShift = true;
    private int priority;

    public static TooltipAttachment multilinesOptional(TooltipFunction function) {
        return new TooltipAttachment(function);
    }

    public static TooltipAttachment multilinesOptional(ItemFilter filter, TooltipFunction function) {
        return TooltipAttachment.multilinesOptional(TooltipFunction.of(filter, function));
    }

    public static TooltipAttachment multilinesOptional(ItemLike itemLike, TooltipFunction function) {
        return TooltipAttachment.multilinesOptional(ItemFilter.of(itemLike), function);
    }

    public static TooltipAttachment multilinesOptional(List<ResourceLocation> itemIds, TooltipFunction function) {
        return TooltipAttachment.multilinesOptional(ItemFilter.of(itemIds), function);
    }

    public static <I extends Item> TooltipAttachment multilinesOptional(Class<I> itemClass, TooltipFunction<I> function) {
        return TooltipAttachment.multilinesOptional(ItemFilter.of(itemClass), function);
    }

    public static TooltipAttachment multilines(ItemFilter filter, TooltipContentFunction function) {
        return TooltipAttachment.multilinesOptional(TooltipFunction.of(filter, function));
    }

    public static TooltipAttachment multilines(ItemLike itemLike, TooltipContentFunction function) {
        return TooltipAttachment.multilines(ItemFilter.of(itemLike), function);
    }

    public static TooltipAttachment multilines(List<ResourceLocation> itemIds, TooltipContentFunction function) {
        return TooltipAttachment.multilines(ItemFilter.of(itemIds), function);
    }

    public static <I extends Item> TooltipAttachment multilines(Class<I> itemClass, TooltipContentFunction<I> function) {
        return TooltipAttachment.multilines(ItemFilter.of(itemClass), function);
    }

    public static TooltipAttachment multilines(ItemFilter filter, List<Component> lines) {
        return TooltipAttachment.multilinesOptional(TooltipFunction.of(filter, lines));
    }

    public static TooltipAttachment multilines(ItemLike itemLike, List<Component> lines) {
        return TooltipAttachment.multilines(ItemFilter.of(itemLike), lines);
    }

    public static TooltipAttachment multilines(List<ResourceLocation> itemIds, List<Component> lines) {
        return TooltipAttachment.multilines(ItemFilter.of(itemIds), lines);
    }

    public static <I extends Item> TooltipAttachment multilines(Class<I> itemClass, List<Component> lines) {
        return TooltipAttachment.multilines(ItemFilter.of(itemClass), lines);
    }

    public static TooltipAttachment singleLineOptional(SingleLineTooltipFunction function) {
        return new TooltipAttachment(function);
    }

    public static TooltipAttachment singleLineOptional(ItemFilter filter, SingleLineTooltipFunction function) {
        return TooltipAttachment.multilinesOptional(TooltipFunction.of(filter, function));
    }

    public static TooltipAttachment singleLineOptional(ItemLike itemLike, SingleLineTooltipFunction function) {
        return TooltipAttachment.singleLineOptional(ItemFilter.of(itemLike), function);
    }

    public static TooltipAttachment singleLineOptional(List<ResourceLocation> itemIds, SingleLineTooltipFunction function) {
        return TooltipAttachment.singleLineOptional(ItemFilter.of(itemIds), function);
    }

    public static <I extends Item> TooltipAttachment singleLineOptional(Class<I> itemClass, SingleLineTooltipFunction<I> function) {
        return TooltipAttachment.singleLineOptional(ItemFilter.of(itemClass), function);
    }

    public static TooltipAttachment singleLine(ItemFilter filter, SingleLineTooltipContentFunction function) {
        return TooltipAttachment.multilinesOptional(TooltipFunction.of(filter, function));
    }

    public static TooltipAttachment singleLine(ItemLike itemLike, SingleLineTooltipContentFunction function) {
        return TooltipAttachment.singleLine(ItemFilter.of(itemLike), function);
    }

    public static TooltipAttachment singleLine(List<ResourceLocation> itemIds, SingleLineTooltipContentFunction function) {
        return TooltipAttachment.singleLine(ItemFilter.of(itemIds), function);
    }

    public static <I extends Item> TooltipAttachment singleLine(Class<I> itemClass, SingleLineTooltipContentFunction<I> function) {
        return TooltipAttachment.singleLine(ItemFilter.of(itemClass), function);
    }

    public static TooltipAttachment singleLine(ItemFilter filter, Component line) {
        return TooltipAttachment.multilinesOptional(TooltipFunction.of(filter, line));
    }

    public static TooltipAttachment singleLine(ItemLike itemLike, Component line) {
        return TooltipAttachment.singleLine(ItemFilter.of(itemLike), line);
    }

    public static TooltipAttachment singleLine(List<ResourceLocation> itemIds, Component line) {
        return TooltipAttachment.singleLine(ItemFilter.of(itemIds), line);
    }

    public static <I extends Item> TooltipAttachment singleLine(Class<I> itemClass, Component line) {
        return TooltipAttachment.singleLine(ItemFilter.of(itemClass), line);
    }

    private TooltipAttachment(TooltipFunction function) {
        this.function = function;
        TooltipHandler.register(this);
    }

    public Optional<List<? extends Component>> lines(TooltipFlag flags, Item.TooltipContext context, ItemStack stack) {
        return this.function.get(flags, context, stack, stack.getItem());
    }

    public boolean requiresShift() {
        return this.requiresShift;
    }

    public TooltipAttachment noShiftRequired() {
        this.requiresShift = false;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public TooltipAttachment priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public int compareTo(TooltipAttachment other) {
        return -Integer.compare(this.priority, other.priority());
    }

    public static interface TooltipFunction<I extends Item> {
        public static TooltipFunction of(ItemFilter filter, TooltipFunction function) {
            return (flags, context, stack, item) -> filter.test(stack, item) ? function.get(flags, context, stack, item) : Optional.empty();
        }

        public static TooltipFunction of(ItemFilter filter, TooltipContentFunction function) {
            return (flags, context, stack, item) -> filter.test(stack, item) ? Optional.of(function.get(flags, context, stack, item)) : Optional.empty();
        }

        public static TooltipFunction of(ItemFilter filter, List<Component> lines) {
            return TooltipFunction.of(filter, (TooltipFlag flags, Item.TooltipContext context, ItemStack stack, I item) -> lines);
        }

        public static TooltipFunction of(ItemFilter filter, Component line) {
            return TooltipFunction.of(filter, List.of(line));
        }

        public Optional<List<? extends Component>> get(TooltipFlag var1, Item.TooltipContext var2, ItemStack var3, I var4);
    }

    public static interface ItemFilter {
        public static ItemFilter of(ItemLike itemLike) {
            return (stack, item) -> item == itemLike.asItem();
        }

        public static ItemFilter of(List<ResourceLocation> itemIds) {
            return (stack, item) -> itemIds.contains(BuiltInRegistries.ITEM.getKey((Object)item));
        }

        public static <I extends Item> ItemFilter of(Class<I> itemClass) {
            return (stack, item) -> itemClass.isAssignableFrom(item.getClass());
        }

        public boolean test(ItemStack var1, Item var2);

        default public boolean test(ItemStack stack) {
            return this.test(stack, stack.getItem());
        }

        default public boolean test(Item item) {
            return this.test(item.getDefaultInstance(), item);
        }
    }

    public static interface TooltipContentFunction<I extends Item> {
        public List<? extends Component> get(TooltipFlag var1, Item.TooltipContext var2, ItemStack var3, I var4);
    }

    public static interface SingleLineTooltipFunction<I extends Item>
    extends TooltipFunction<I> {
        public Optional<Component> getSingleLine(TooltipFlag var1, Item.TooltipContext var2, ItemStack var3, I var4);

        @Override
        default public Optional<List<? extends Component>> get(TooltipFlag flags, Item.TooltipContext context, ItemStack stack, I item) {
            return this.getSingleLine(flags, context, stack, item).map(List::of);
        }
    }

    public static interface SingleLineTooltipContentFunction<I extends Item>
    extends TooltipContentFunction<I> {
        public Component getSingleLine(TooltipFlag var1, Item.TooltipContext var2, ItemStack var3, I var4);

        @Override
        default public List<? extends Component> get(TooltipFlag flags, Item.TooltipContext context, ItemStack stack, I item) {
            return List.of(this.getSingleLine(flags, context, stack, item));
        }
    }
}

