/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.guigraphics;

import net.minecraft.util.FastColor;

public interface ColoredGuiGraphics {
    public int[] getColor();

    default public int getColorARGB() {
        int[] color = this.getColor();
        return FastColor.ARGB32.color((int)color[3], (int)color[0], (int)color[1], (int)color[2]);
    }

    default public void setColor(int argb) {
        this.setColorInt(FastColor.ARGB32.red((int)argb), FastColor.ARGB32.green((int)argb), FastColor.ARGB32.blue((int)argb), FastColor.ARGB32.alpha((int)argb));
    }

    default public void setColor(int[] rgba) {
        this.setColorInt(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    default public void setColor(float red, float green, float blue, float alpha) {
        this.setColorInt((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public void setColorInt(int var1, int var2, int var3, int var4);

    public void revertColor();

    default public void resetColor() {
        this.setColorInt(255, 255, 255, 255);
    }
}

