/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.vanilla.recipe;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.swedz.tesseract.neoforge.helper.RecipeHelper;
import net.swedz.tesseract.neoforge.recipe.RecipeBuilder;

public class SmeltingRecipeBuilder
extends RecipeBuilder {
    protected Ingredient input;
    protected int cookingTime;
    protected float experience;
    protected boolean blasting;

    public Ingredient input() {
        return this.input;
    }

    public SmeltingRecipeBuilder input(Ingredient input) {
        if (input == null || input == Ingredient.EMPTY) {
            throw new NullPointerException("Input ingredient cannot be null or empty");
        }
        this.input = input;
        return this;
    }

    public SmeltingRecipeBuilder input(ItemLike ... items) {
        return this.input(Ingredient.of((ItemLike[])items));
    }

    public SmeltingRecipeBuilder input(ItemStack ... stacks) {
        return this.input(Ingredient.of((ItemStack[])stacks));
    }

    public SmeltingRecipeBuilder input(TagKey<Item> tag) {
        return this.input(Ingredient.of(tag));
    }

    public SmeltingRecipeBuilder input(ResourceLocation ... itemIds) {
        return this.input(RecipeHelper.ingredient(itemIds));
    }

    public SmeltingRecipeBuilder input(String maybeTag) {
        return this.input(RecipeHelper.ingredient(maybeTag));
    }

    public int cookingTime() {
        return this.cookingTime;
    }

    public SmeltingRecipeBuilder cookingTime(int cookingTime) {
        if (cookingTime <= 0) {
            throw new IllegalArgumentException("Cooking time must be positive");
        }
        this.cookingTime = cookingTime;
        return this;
    }

    public float experience() {
        return this.experience;
    }

    public SmeltingRecipeBuilder experience(float experience) {
        if (experience < 0.0f) {
            throw new IllegalArgumentException("Experience must be positive or 0");
        }
        this.experience = experience;
        return this;
    }

    public boolean isBlasting() {
        return this.blasting;
    }

    public SmeltingRecipeBuilder blasting() {
        this.blasting = true;
        return this;
    }

    @Override
    public void validate() {
        if (this.input == null || this.input == Ingredient.EMPTY) {
            throw new IllegalArgumentException("No input ingredient was provided");
        }
        if (this.cookingTime == 0) {
            throw new IllegalArgumentException("No cooking time was provided");
        }
    }

    @Override
    public Recipe<?> convert() {
        AbstractCookingRecipe.Factory factory = this.blasting ? BlastingRecipe::new : SmeltingRecipe::new;
        return factory.create("", CookingBookCategory.MISC, this.input, this.result, this.experience, this.cookingTime);
    }

    @Override
    public SmeltingRecipeBuilder output(ItemStack result) {
        super.output(result);
        return this;
    }

    @Override
    public SmeltingRecipeBuilder output(ItemLike result, int count) {
        super.output(result, count);
        return this;
    }

    @Override
    public SmeltingRecipeBuilder output(String result, int count) {
        super.output(result, count);
        return this;
    }
}

