/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.MultipliedCrafterComponent;
import net.swedz.tesseract.neoforge.compat.mi.helper.CommonGuiComponents;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.BasicMultiblockMachineBlockEntity;

public abstract class AbstractMultipliedCraftingMultiblockBlockEntity
extends BasicMultiblockMachineBlockEntity
implements CrafterComponentHolder,
ModularCrafterAccessBehavior {
    protected final MultipliedCrafterComponent crafter;
    protected OperatingState operatingState = OperatingState.NOT_MATCHED;

    public AbstractMultipliedCraftingMultiblockBlockEntity(BEP bep, ResourceLocation id, ShapeTemplate[] shapeTemplates) {
        super(bep, new MachineGuiParameters.Builder(id, false).backgroundHeight(200).build(), shapeTemplates);
        this.crafter = new MultipliedCrafterComponent((MachineBlockEntity)this, (CrafterComponent.Inventory)this.inventory, this, this::getRecipeType, this::getMaxMultiplier, this::getEuCostTransformer);
        this.registerComponents(new IComponent[]{this.crafter});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new ReiSlotLocking.Server(this.crafter::lockRecipe, () -> this.operatingState != OperatingState.NOT_MATCHED);
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{CommonGuiComponents.standardMultiblockScreen((MultiblockMachineBlockEntity)this, this.crafter, this.isActive)});
    }

    public abstract MachineRecipeType getRecipeType();

    public abstract int getMaxMultiplier();

    public abstract EuCostTransformer getEuCostTransformer();

    public CrafterAccess getCrafterComponent() {
        return this.crafter;
    }

    @Override
    public ServerLevel getCrafterWorld() {
        return (ServerLevel)this.level;
    }

    @Override
    public UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        this.operatingState = OperatingState.NOT_MATCHED;
        if (shapeMatcher.isMatchSuccessful()) {
            this.operatingState = OperatingState.TRYING_TO_RESUME;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            boolean newActive = false;
            if (this.operatingState == OperatingState.TRYING_TO_RESUME && this.crafter.tryContinueRecipe()) {
                this.operatingState = OperatingState.NORMAL_OPERATION;
            }
            if (this.operatingState == OperatingState.NORMAL_OPERATION) {
                if (this.crafter.tickRecipe()) {
                    newActive = true;
                }
            } else {
                this.crafter.decreaseEfficiencyTicks();
            }
            this.updateActive(newActive);
        }
        this.tickExtra();
    }

    public void tickExtra() {
    }

    public static enum OperatingState {
        NOT_MATCHED,
        TRYING_TO_RESUME,
        NORMAL_OPERATION;

    }
}

