/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied;

import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.api.MachineTierHolder;
import net.swedz.tesseract.neoforge.compat.mi.helper.ModularLubricantHelper;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractMultipliedCraftingMultiblockBlockEntity;

public abstract class AbstractElectricMultipliedCraftingMultiblockBlockEntity
extends AbstractMultipliedCraftingMultiblockBlockEntity
implements EnergyListComponentHolder,
MachineTierHolder {
    protected final MachineTier machineTier;
    protected final UpgradeComponent upgrades;
    protected final RedstoneControlComponent redstoneControl;
    protected final OverdriveComponent overdrive;
    protected final List<EnergyComponent> energyInputs = Lists.newArrayList();

    public AbstractElectricMultipliedCraftingMultiblockBlockEntity(BEP bep, ResourceLocation id, ShapeTemplate[] shapeTemplates, MachineTier machineTier) {
        super(bep, id, shapeTemplates);
        this.machineTier = machineTier;
        this.upgrades = new UpgradeComponent();
        this.redstoneControl = new RedstoneControlComponent();
        this.overdrive = new OverdriveComponent();
        this.registerComponents(new IComponent[]{this.upgrades, this.redstoneControl, this.overdrive});
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withOverdrive(this.overdrive)});
    }

    public List<? extends EnergyAccess> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    public MachineTier getMachineTier() {
        return this.machineTier;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = ModularLubricantHelper.onUse(this.crafter, player, hand);
        }
        if (!result.consumesAction()) {
            result = (ItemInteractionResult)this.components.mapOrDefault(UpgradeComponent.class, upgrade -> upgrade.onUse((MachineBlockEntity)this, player, hand), (Object)result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = (ItemInteractionResult)this.components.mapOrDefault(OverdriveComponent.class, overdrive -> overdrive.onUse((MachineBlockEntity)this, player, hand), (Object)result);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, simulation);
        }
        return total;
    }

    @Override
    public long getBaseRecipeEu() {
        return this.machineTier.getBaseEu();
    }

    @Override
    public long getBaseMaxRecipeEu() {
        return this.machineTier.getMaxEu();
    }

    @Override
    public long getMaxRecipeEuBonus() {
        return this.upgrades.getAddMaxEUPerTick();
    }

    @Override
    public boolean isOverdriving() {
        return this.overdrive.shouldOverdrive();
    }

    public List<Component> getTooltips() {
        return List.of(TesseractMI.text().machineBatcherRecipe(true, this.getRecipeType()), TesseractMI.text().machineBatcherSizeAndCost(this.getMaxMultiplier(), this.getEuCostTransformer()));
    }
}

