/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.Styles;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GadgetExchanger
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.EXCHANGINGGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.EXCHANGINGGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (sneakPressed) {
            BaseMode mode = GadgetNBT.getMode(stack);
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.mode", (Object[])new Object[]{Component.translatable((String)mode.i18n())}).setStyle(Styles.AQUA));
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.range", (Object[])new Object[]{GadgetNBT.getToolRange(stack)}).setStyle(Styles.LT_PURPLE));
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.blockstate", (Object[])new Object[]{GadgetNBT.getGadgetBlockState(stack).getBlock().getName()}).setStyle(Styles.DK_GREEN));
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BlockState setState = GadgetNBT.getGadgetBlockState(gadget);
        if (setState.isAir()) {
            return InteractionResultHolder.pass((Object)gadget);
        }
        BaseMode mode = GadgetNBT.getMode(gadget);
        ArrayList<StatePos> buildList = mode.collect(context.hitResult().getDirection(), context.player(), GadgetExchanger.getHitPos(context), setState);
        UUID buildUUID = BuildingUtils.exchange(context.level(), context.player(), buildList, GadgetExchanger.getHitPos(context), gadget, true, true);
        GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
        GadgetNBT.clearAnchorPos(gadget);
        return InteractionResultHolder.success((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        BlockState blockState = context.level().getBlockState(context.pos());
        if (!GadgetUtils.isValidBlockState(blockState, context.level(), context.pos()) || blockState.getBlock() instanceof RenderBlock) {
            context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.invalidblock"), true);
            return super.onShiftAction(context);
        }
        if (GadgetUtils.setBlockState(context.stack(), blockState)) {
            return InteractionResultHolder.success((Object)context.stack());
        }
        return super.onShiftAction(context);
    }

    @Override
    public void undo(Level level, Player player, ItemStack gadget) {
        if (!this.canUndo(level, player, gadget)) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        UUID buildUUID = GadgetNBT.popUndoList(gadget);
        ServerTickHandler.stopBuilding(buildUUID);
        ArrayList<StatePos> undoList = bg2Data.popUndoList(buildUUID);
        if (undoList.isEmpty()) {
            return;
        }
        Collections.reverse(undoList);
        UUID newBuildUUID = UUID.randomUUID();
        for (StatePos pos : undoList) {
            if (pos.state.isAir() || !pos.state.canSurvive((LevelReader)level, pos.pos)) continue;
            if (!player.isCreative() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            if (!player.isCreative()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(newBuildUUID, new StatePos(pos.state, pos.pos), level, GadgetNBT.getRenderTypeByte(gadget), player, true, true, gadget, ServerBuildList.BuildType.EXCHANGE, true, GadgetNBT.nullPos);
        }
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.EXCHANGING;
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public int getEnchantmentValue() {
        return 3;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.isPrimaryItemFor(stack, enchantment) && this.canAcceptEnchantments(enchantment);
    }

    private boolean canAcceptEnchantments(Holder<Enchantment> enchantment) {
        return !enchantment.is(Enchantments.FORTUNE);
    }
}

