/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextRenderUtils {
    private TextRenderUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Font getFontRenderer() {
        return Minecraft.getInstance().font;
    }

    public static void renderScaled(GuiGraphics graphics, Font font, FormattedCharSequence text, int x, int y, float scale, int color, boolean shadow) {
        PoseStack matrix = graphics.pose();
        matrix.pushPose();
        matrix.scale(scale, scale, scale);
        graphics.drawString(font, text, (float)x / scale, (float)y / scale, color, shadow);
        matrix.popPose();
    }

    public static void renderSplit(GuiGraphics graphics, Font font, FormattedText text, int x, int y, int width, int color, boolean shadow) {
        List list = font.split(text, width);
        for (int i = 0; i < list.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)list.get(i);
            Objects.requireNonNull(font);
            int yTranslated = y + i * 9;
            graphics.drawString(font, line, x, yTranslated, color, shadow);
        }
    }

    public static void renderSplitScaled(GuiGraphics graphics, Font font, FormattedText text, int x, int y, float scale, int color, boolean shadow, int length) {
        List lines = font.split(text, (int)((float)length / scale));
        for (int i = 0; i < lines.size(); ++i) {
            Objects.requireNonNull(font);
            int yTranslated = y + i * (int)(9.0f * scale + 3.0f);
            TextRenderUtils.renderScaled(graphics, font, (FormattedCharSequence)lines.get(i), x, yTranslated, scale, color, shadow);
        }
    }
}

