/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.storage;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.DISKDrive;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import io.github.projectet.ae2things.util.DataStorage;
import io.github.projectet.ae2things.util.StorageManager;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DISKCellInventory
implements StorageCell {
    private final IDISKCellItem cellType;
    private final ISaveProvider container;
    private final AEKeyType keyType;
    @Nullable
    private final StorageManager storageManager;
    private IPartitionList partitionList;
    private IncludeExclude partitionListMode;
    private int storedItems;
    private long storedItemCount;
    private Object2LongMap<AEKey> storedAmounts;
    private final ItemStack i;
    private boolean isPersisted = true;

    public DISKCellInventory(IDISKCellItem cellType, ItemStack stack, ISaveProvider saveProvider, @Nullable StorageManager storageManager) {
        this.cellType = cellType;
        this.i = stack;
        this.container = saveProvider;
        this.keyType = cellType.getKeyType();
        this.storageManager = storageManager;
        this.storedAmounts = null;
        this.initData();
        this.updateFilter();
    }

    private void updateFilter() {
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        boolean hasInverter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        if (upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD)) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        builder.addAll((Iterable)config.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
    }

    private DataStorage getDiskStorage() {
        if (this.getDiskUUID() != null && this.storageManager != null) {
            return this.storageManager.getOrCreateDisk(this.getDiskUUID());
        }
        return DataStorage.EMPTY;
    }

    private void initData() {
        if (this.hasDiskUUID()) {
            this.storedItems = this.getDiskStorage().stackAmounts.length;
            this.storedItemCount = this.getDiskStorage().itemCount;
        } else {
            this.storedItems = 0;
            this.storedItemCount = 0L;
            this.getCellItems();
        }
    }

    public IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    public boolean isPreformatted() {
        return !this.partitionList.isEmpty();
    }

    public boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    public ConfigInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.i);
    }

    public IUpgradeInventory getUpgradesInventory() {
        return this.cellType.getUpgrades(this.i);
    }

    public CellState getStatus() {
        if (this.getStoredItemCount() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    public CellState getClientStatus() {
        if (this.getNbtItemCount() == 0L) {
            return CellState.EMPTY;
        }
        if (this.getNbtItemCount() > 0L && this.getNbtItemCount() != this.getTotalBytes()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public void persist() {
        if (this.isPersisted || this.storageManager == null) {
            return;
        }
        if (this.storedItemCount == 0L) {
            if (this.hasDiskUUID()) {
                this.storageManager.removeDisk(this.getDiskUUID());
                this.i.remove(AE2Things.DATA_DISK_ID);
                this.i.remove(AE2Things.DATA_DISK_ITEM_COUNT);
                this.initData();
            }
            return;
        }
        long itemCount = 0L;
        LongArrayList amounts = new LongArrayList(this.storedAmounts.size());
        ListTag keys = new ListTag();
        for (Object2LongMap.Entry entry : this.storedAmounts.object2LongEntrySet()) {
            long amount = entry.getLongValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric(this.storageManager.getRegistries()));
            amounts.add(amount);
        }
        if (keys.isEmpty()) {
            this.storageManager.updateDisk(this.getDiskUUID(), new DataStorage());
        } else {
            this.storageManager.modifyDisk(this.getDiskUUID(), keys, amounts.toArray(new long[0]), itemCount);
        }
        this.storedItems = (short)this.storedAmounts.size();
        this.storedItemCount = itemCount;
        this.i.set(AE2Things.DATA_DISK_ITEM_COUNT, (Object)itemCount);
        this.isPersisted = true;
    }

    public Component getDescription() {
        return null;
    }

    public static DISKCellInventory createInventory(ItemStack stack, ISaveProvider saveProvider, @Nullable StorageManager storageManager) {
        Objects.requireNonNull(stack, "Cannot create cell inventory for null itemstack");
        Item item = stack.getItem();
        if (!(item instanceof IDISKCellItem)) {
            return null;
        }
        IDISKCellItem cellType = (IDISKCellItem)item;
        if (!cellType.isStorageCell(stack)) {
            return null;
        }
        return new DISKCellInventory(cellType, stack, saveProvider, storageManager);
    }

    public boolean hasDiskUUID() {
        return this.i.has(AE2Things.DATA_DISK_ID);
    }

    public static boolean hasDiskUUID(ItemStack disk) {
        if (disk.getItem() instanceof IDISKCellItem) {
            return disk.has(AE2Things.DATA_DISK_ID);
        }
        return false;
    }

    @Nullable
    public UUID getDiskUUID() {
        return (UUID)this.i.get(AE2Things.DATA_DISK_ID);
    }

    private boolean isStorageCell(AEItemKey key) {
        DISKDrive type = DISKCellInventory.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    private static DISKDrive getStorageCell(AEItemKey itemKey) {
        Item item = itemKey.getItem();
        if (item instanceof DISKDrive) {
            DISKDrive diskDrive = (DISKDrive)item;
            return diskDrive;
        }
        return null;
    }

    private static boolean isCellEmpty(DISKCellInventory inv) {
        if (inv != null) {
            return inv.getAvailableStacks().isEmpty();
        }
        return true;
    }

    protected Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellItems().object2LongEntrySet()) {
            out.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    private void loadCellItems() {
        if (this.storageManager == null) {
            return;
        }
        DataStorage diskStorage = this.getDiskStorage();
        long[] amounts = diskStorage.stackAmounts;
        ListTag tags = diskStorage.stackKeys;
        if (amounts.length != tags.size()) {
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])new Object[]{amounts.length, tags.size()});
        }
        boolean corruptedTag = false;
        HolderLookup.Provider registries = this.storageManager.getRegistries();
        for (int i = 0; i < amounts.length; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)tags.getCompound(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            this.storedAmounts.put((Object)key, amount);
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    protected void saveChanges() {
        this.storedItems = this.storedAmounts.size();
        this.storedItemCount = 0L;
        for (Long storedAmount : this.storedAmounts.values()) {
            this.storedItemCount += storedAmount.longValue();
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long getRemainingItemCount() {
        return this.getFreeBytes() > 0L ? this.getFreeBytes() : 0L;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        DISKCellInventory meInventory;
        AEItemKey itemKey;
        if (amount == 0L || !this.keyType.contains(what)) {
            return 0L;
        }
        if (!this.partitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        if (this.cellType.isBlackListed(this.i, what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && this.isStorageCell(itemKey = (AEItemKey)what) && !DISKCellInventory.isCellEmpty(meInventory = DISKCellInventory.createInventory(itemKey.toStack(), null, this.storageManager))) {
            return 0L;
        }
        if (this.storageManager != null && !this.hasDiskUUID()) {
            this.i.set(AE2Things.DATA_DISK_ID, (Object)UUID.randomUUID());
            this.storageManager.getOrCreateDisk(this.getDiskUUID());
            this.loadCellItems();
        }
        long currentAmount = this.getCellItems().getLong((Object)what);
        long remainingItemCount = this.getRemainingItemCount();
        if (amount > remainingItemCount) {
            amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            this.getCellItems().put((Object)what, currentAmount + amount);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.getCellItems().getLong((Object)what);
        if (currentAmount > 0L) {
            if (extractAmount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    this.getCellItems().remove((Object)what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                this.getCellItems().put((Object)what, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getStoredItemCount();
    }

    public long getNbtItemCount() {
        if (this.hasDiskUUID()) {
            return (Long)this.i.getOrDefault(AE2Things.DATA_DISK_ITEM_COUNT, (Object)0L);
        }
        return 0L;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public boolean canHoldNewItem() {
        return this.getFreeBytes() > 0L && this.getFreeBytes() != this.getTotalBytes();
    }
}

