/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.storage;

import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.DISKDrive;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class DISKCellHandler
implements ICellHandler {
    public static final DISKCellHandler INSTANCE = new DISKCellHandler();

    public boolean isCell(ItemStack is) {
        return is.getItem() instanceof DISKDrive;
    }

    public DISKCellInventory getCellInventory(ItemStack is, ISaveProvider container) {
        return DISKCellInventory.createInventory(is, container, AE2Things.currentStorageManager());
    }

    public void addCellInformationToTooltip(ItemStack stack, List<Component> lines) {
        DISKCellInventory handler = DISKCellInventory.createInventory(stack, null, null);
        if (handler == null) {
            return;
        }
        if (handler.hasDiskUUID()) {
            lines.add((Component)Component.literal((String)"Disk UUID: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)handler.getDiskUUID().toString()).withStyle(ChatFormatting.AQUA)));
            lines.add(Tooltips.bytesUsed((long)handler.getNbtItemCount(), (long)handler.getTotalBytes()));
        }
        if (handler.isPreformatted()) {
            MutableComponent list = (handler.getPartitionListMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).text();
            if (handler.isFuzzy()) {
                lines.add((Component)GuiText.Partitioned.withSuffix(" - ").append((Component)list).append(" ").append((Component)GuiText.Fuzzy.text()));
            } else {
                lines.add((Component)GuiText.Partitioned.withSuffix(" - ").append((Component)list).append(" ").append((Component)GuiText.Precise.text()));
            }
        }
    }
}

