/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.OctahedralGroup;
import commoble.morered.client.ClientProxy;
import commoble.morered.util.DirectionHelper;
import commoble.morered.util.EightGroup;
import commoble.morered.wires.Edge;
import commoble.morered.wires.VoxelCache;
import commoble.morered.wires.WireUpdateBuffer;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.event.EventHooks;

public abstract class AbstractWireBlock
extends Block {
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty[] INTERIOR_FACES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    public static final EnumProperty<OctahedralGroup> TRANSFORM = EightGroup.TRANSFORM;
    protected final VoxelShape[] shapesByStateIndex;
    protected final VoxelShape[] raytraceBackboards;
    protected final LoadingCache<Long, VoxelShape> voxelCache;
    protected final boolean useIndirectPower;

    public static VoxelShape[] makeVoxelShapes(VoxelShape[] nodeShapes, VoxelShape[] lineShapes) {
        VoxelShape[] result = new VoxelShape[64];
        for (int i = 0; i < 64; ++i) {
            VoxelShape nextShape = Shapes.empty();
            boolean[] addedSides = new boolean[6];
            for (int side = 0; side < 6; ++side) {
                if ((i & 1 << side) == 0) continue;
                nextShape = Shapes.or((VoxelShape)nextShape, (VoxelShape)nodeShapes[side]);
                int sideAxis = side / 2;
                for (int secondarySide = 0; secondarySide < side; ++secondarySide) {
                    if (!addedSides[secondarySide] || sideAxis == secondarySide / 2) continue;
                    nextShape = Shapes.or((VoxelShape)nextShape, (VoxelShape)AbstractWireBlock.getLineShape(lineShapes, side, DirectionHelper.getCompressedSecondSide(side, secondarySide)));
                    nextShape = Shapes.or((VoxelShape)nextShape, (VoxelShape)AbstractWireBlock.getLineShape(lineShapes, secondarySide, DirectionHelper.getCompressedSecondSide(secondarySide, side)));
                }
                addedSides[side] = true;
            }
            result[i] = nextShape;
        }
        return result;
    }

    public static VoxelShape getLineShape(VoxelShape[] lineShapes, int side, int secondarySide) {
        return lineShapes[side * 4 + secondarySide];
    }

    public static int getShapeIndex(BlockState state) {
        int index = 0;
        int sideCount = INTERIOR_FACES.length;
        for (int side = 0; side < sideCount; ++side) {
            if (!((Boolean)state.getValue((Property)INTERIOR_FACES[side])).booleanValue()) continue;
            index |= 1 << side;
        }
        return index;
    }

    public static VoxelShape makeExpandedShapeForIndex(VoxelShape[] shapesByStateIndex, VoxelShape[] lineShapes, long index) {
        int primaryShapeIndex = (int)(index & 0x3FL);
        long expandedShapeIndex = index >> 6;
        VoxelShape shape = shapesByStateIndex[primaryShapeIndex];
        int flag = 1;
        for (int side = 0; side < 6; ++side) {
            for (int subSide = 0; subSide < 4; ++subSide) {
                if ((expandedShapeIndex & (long)flag) != 0L) {
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)AbstractWireBlock.getLineShape(lineShapes, side, subSide));
                }
                flag <<= 1;
            }
        }
        return shape;
    }

    public static LoadingCache<Long, VoxelShape> makeVoxelCache(final VoxelShape[] shapesByStateIndex, final VoxelShape[] lineShapes) {
        return CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, VoxelShape>(){

            public VoxelShape load(Long key) throws Exception {
                return AbstractWireBlock.makeExpandedShapeForIndex(shapesByStateIndex, lineShapes, key);
            }
        });
    }

    public static boolean canWireConnectToAdjacentWireOrCable(BlockGetter world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        BlockPos diagonalPos;
        BlockState diagonalState;
        if (wireFace.getAxis() != directionToWire.getAxis() && ((Boolean)thisState.getValue((Property)INTERIOR_FACES[wireFace.ordinal()])).booleanValue()) {
            return true;
        }
        Block wireBlock = wireState.getBlock();
        return wireBlock == thisState.getBlock() && (diagonalState = world.getBlockState(diagonalPos = thisPos.relative(wireFace))).getBlock() == wireBlock && (Boolean)diagonalState.getValue((Property)INTERIOR_FACES[directionToWire.ordinal()]) != false;
    }

    public AbstractWireBlock(BlockBehaviour.Properties properties, VoxelShape[] shapesByStateIndex, VoxelShape[] raytraceBackboards, LoadingCache<Long, VoxelShape> voxelCache, boolean useIndirectPower) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue(TRANSFORM, (Comparable)OctahedralGroup.IDENTITY));
        this.shapesByStateIndex = shapesByStateIndex;
        this.raytraceBackboards = raytraceBackboards;
        this.voxelCache = voxelCache;
        this.useIndirectPower = useIndirectPower;
    }

    protected abstract boolean canAdjacentBlockConnectToFace(BlockGetter var1, BlockPos var2, BlockState var3, Block var4, Direction var5, Direction var6, BlockPos var7, BlockState var8);

    protected abstract void updatePowerAfterBlockUpdate(Level var1, BlockPos var2, BlockState var3);

    protected abstract void notifyNeighbors(Level var1, BlockPos var2, BlockState var3, EnumSet<Direction> var4, boolean var5);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, TRANSFORM});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            voxelShape = VoxelCache.get(level, pos);
        } else {
            voxelShape = this.shapesByStateIndex[AbstractWireBlock.getShapeIndex(state)];
        }
        return voxelShape;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.shapesByStateIndex[AbstractWireBlock.getShapeIndex(state)];
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return this.isEmptyWireBlock(state);
    }

    public BlockState updateShape(BlockState thisState, Direction directionToNeighbor, BlockState neighborState, LevelAccessor world, BlockPos thisPos, BlockPos neighborPos) {
        BooleanProperty sideProperty = INTERIOR_FACES[directionToNeighbor.ordinal()];
        if (((Boolean)thisState.getValue((Property)sideProperty)).booleanValue()) {
            Direction neighborSide = directionToNeighbor.getOpposite();
            boolean isNeighborSideSolid = neighborState.isFaceSturdy((BlockGetter)world, neighborPos, neighborSide);
            if (!isNeighborSideSolid && world instanceof ServerLevel) {
                Block.dropResources((BlockState)((BlockState)this.defaultBlockState().setValue((Property)sideProperty, (Comparable)Boolean.valueOf(true))), (Level)((ServerLevel)world), (BlockPos)thisPos);
            }
            return (BlockState)thisState.setValue((Property)sideProperty, (Comparable)Boolean.valueOf(isNeighborSideSolid));
        }
        return thisState;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction[] dirs = Direction.values();
        for (int side = 0; side < 6; ++side) {
            Direction neighborSide;
            Direction dir;
            BlockPos neighborPos;
            BlockState neighborState;
            if (!((Boolean)state.getValue((Property)INTERIOR_FACES[side])).booleanValue() || (neighborState = world.getBlockState(neighborPos = pos.relative(dir = dirs[side]))).isFaceSturdy((BlockGetter)world, neighborPos, neighborSide = dir.getOpposite())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        Direction sideOfNeighbor = context.getClickedFace();
        Direction directionToNeighbor = sideOfNeighbor.getOpposite();
        BlockPos placePos = context.getClickedPos();
        BlockPos neighborPos = placePos.relative(directionToNeighbor);
        BlockState neighborState = world.getBlockState(neighborPos);
        return neighborState.isFaceSturdy((BlockGetter)world, neighborPos, sideOfNeighbor) ? (BlockState)this.defaultBlockState().setValue((Property)INTERIOR_FACES[directionToNeighbor.ordinal()], (Comparable)Boolean.valueOf(true)) : null;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        ClientProxy.initializeAbstractWireBlockClient(this, consumer);
    }

    @Deprecated
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateShapeCache(worldIn, pos);
        super.onPlace(state, worldIn, pos, oldState, isMoving);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.isClientSide) {
            for (Direction directionToNeighbor : Direction.values()) {
                BlockPos neighborPos = pos.relative(directionToNeighbor);
                BlockState neighborState = worldIn.getBlockState(neighborPos);
                if (!neighborState.isAir()) continue;
                this.addEmptyWireToAir(state, worldIn, neighborPos, directionToNeighbor);
            }
        }
        this.updateShapeCache(worldIn, pos);
        this.updatePowerAfterBlockUpdate(worldIn, pos, state);
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    @Deprecated
    public void onRemove(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean doPowerUpdate = true;
        if (newState.getBlock() != this) {
            this.notifyNeighbors(worldIn, pos, newState, EnumSet.allOf(Direction.class), this.useIndirectPower);
            doPowerUpdate = false;
        } else if (this.isEmptyWireBlock(newState)) {
            long edgeFlags = this.getEdgeFlags((BlockGetter)worldIn, pos);
            if (edgeFlags == 0L) {
                worldIn.removeBlock(pos, false);
            } else {
                this.notifyNeighbors(worldIn, pos, newState, EnumSet.allOf(Direction.class), this.useIndirectPower);
            }
            doPowerUpdate = false;
        }
        this.updateShapeCache(worldIn, pos);
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
        if (doPowerUpdate) {
            this.updatePowerAfterBlockUpdate(worldIn, pos, newState);
        }
    }

    @Deprecated
    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        BlockPos offset = fromPos.subtract((Vec3i)pos);
        Direction directionToNeighbor = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
        long edgeFlags = this.getEdgeFlags((BlockGetter)worldIn, pos);
        if (this.isEmptyWireBlock(state)) {
            if (edgeFlags == 0L) {
                worldIn.removeBlock(pos, false);
            }
        } else if (worldIn.isEmptyBlock(fromPos) && directionToNeighbor != null) {
            this.addEmptyWireToAir(state, worldIn, fromPos, directionToNeighbor);
        }
        this.updateShapeCache(worldIn, pos);
        this.updatePowerAfterBlockUpdate(worldIn, pos, state);
        if (edgeFlags != 0L) {
            EnumSet<Direction> edgeUpdateDirs = EnumSet.noneOf(Direction.class);
            Edge[] edges = Edge.values();
            for (int edgeFlag = 0; edgeFlag < 12; ++edgeFlag) {
                if ((edgeFlags & (long)(1 << edgeFlag)) == 0L) continue;
                Edge edge = edges[edgeFlag];
                if (edge.sideA == directionToNeighbor) {
                    edgeUpdateDirs.add(edge.sideB);
                    continue;
                }
                if (edge.sideB != directionToNeighbor) continue;
                edgeUpdateDirs.add(edge.sideA);
            }
            if (!edgeUpdateDirs.isEmpty() && !EventHooks.onNeighborNotify((Level)worldIn, (BlockPos)pos, (BlockState)state, edgeUpdateDirs, (boolean)false).isCanceled()) {
                BlockPos.MutableBlockPos mutaPos = pos.mutable();
                for (Direction dir : edgeUpdateDirs) {
                    BlockPos.MutableBlockPos neighborPos = mutaPos.setWithOffset((Vec3i)pos, dir);
                    worldIn.neighborChanged((BlockPos)neighborPos, (Block)this, pos);
                }
            }
        }
        super.neighborChanged(state, worldIn, pos, neighborBlock, fromPos, isMoving);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        BlockState result = state;
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.from2DDataValue((int)i);
            Direction newDir = rot.rotate(dir);
            result = (BlockState)result.setValue((Property)INTERIOR_FACES[newDir.ordinal()], (Comparable)((Boolean)state.getValue((Property)INTERIOR_FACES[dir.ordinal()])));
        }
        result = EightGroup.rotate(result, rot);
        return result;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        BlockState result = state;
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.from2DDataValue((int)i);
            Direction newDir = mirrorIn.mirror(dir);
            result = (BlockState)result.setValue((Property)INTERIOR_FACES[newDir.ordinal()], (Comparable)((Boolean)state.getValue((Property)INTERIOR_FACES[dir.ordinal()])));
        }
        result = EightGroup.mirror(result, mirrorIn);
        return result;
    }

    public int getWireCount(BlockState state) {
        int count = 0;
        for (int side = 0; side < 6; ++side) {
            if (!((Boolean)state.getValue((Property)INTERIOR_FACES[side])).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmptyWireBlock(BlockState state) {
        return state == this.defaultBlockState();
    }

    protected long getEdgeFlags(BlockGetter world, BlockPos pos) {
        long result = 0L;
        for (int edge = 0; edge < 12; ++edge) {
            if (!Edge.values()[edge].shouldEdgeRender(world, pos, this)) continue;
            result |= 1L << edge;
        }
        return result;
    }

    protected long getEdgeFlagsForNodeLineEdgeFormat(BlockGetter world, BlockPos pos) {
        return this.getEdgeFlags(world, pos) << 30;
    }

    @Nullable
    public Direction getInteriorFaceToBreak(BlockState state, BlockPos pos, Player player, BlockHitResult raytrace, float partialTicks) {
        Vec3 lookOffset = player.getViewVector(partialTicks);
        Vec3 hitVec = raytrace.getLocation();
        Vec3 relativeHitVec = hitVec.add(lookOffset.multiply(0.001, 0.001, 0.001)).subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        for (int side = 0; side < 6; ++side) {
            if (!((Boolean)state.getValue((Property)INTERIOR_FACES[side])).booleanValue()) continue;
            VoxelShape faceShape = this.raytraceBackboards[side];
            for (AABB aabb : faceShape.toAabbs()) {
                if (!aabb.contains(relativeHitVec)) continue;
                return Direction.from3DDataValue((int)side);
            }
        }
        return null;
    }

    protected void updateShapeCache(Level world, BlockPos pos) {
        VoxelCache.invalidate(world, pos);
        for (int i = 0; i < 6; ++i) {
            VoxelCache.invalidate(world, pos.relative(Direction.from3DDataValue((int)i)));
        }
        if (world instanceof ServerLevel) {
            WireUpdateBuffer.get((ServerLevel)world).enqueue(pos);
        }
    }

    protected void addEmptyWireToAir(BlockState thisState, Level world, BlockPos neighborAirPos, Direction directionToNeighbor) {
        Direction directionFromNeighbor = directionToNeighbor.getOpposite();
        for (Direction dir : Direction.values()) {
            BooleanProperty thisAttachmentFace;
            if (dir == directionToNeighbor || dir == directionFromNeighbor || !((Boolean)thisState.getValue((Property)(thisAttachmentFace = INTERIOR_FACES[dir.ordinal()]))).booleanValue()) continue;
            BlockPos diagonalNeighbor = neighborAirPos.relative(dir);
            BooleanProperty neighborAttachmentFace = INTERIOR_FACES[directionFromNeighbor.ordinal()];
            BlockState diagonalState = world.getBlockState(diagonalNeighbor);
            if (diagonalState.getBlock() != this || !((Boolean)diagonalState.getValue((Property)neighborAttachmentFace)).booleanValue()) continue;
            world.setBlockAndUpdate(neighborAirPos, this.defaultBlockState());
            break;
        }
    }

    public void destroyClickedSegment(BlockState state, Level world, BlockPos pos, Player player, Direction interiorFace, boolean dropItems) {
        int side = interiorFace.ordinal();
        BooleanProperty sideProperty = INTERIOR_FACES[side];
        if (((Boolean)state.getValue((Property)sideProperty)).booleanValue()) {
            BlockState newState = (BlockState)state.setValue((Property)sideProperty, (Comparable)Boolean.valueOf(false));
            Block newBlock = newState.getBlock();
            BlockState removedState = (BlockState)newBlock.defaultBlockState().setValue((Property)sideProperty, (Comparable)Boolean.valueOf(true));
            Block removedBlock = removedState.getBlock();
            if (dropItems) {
                removedBlock.playerDestroy(world, player, pos, removedState, null, player.getMainHandItem().copy());
            }
            if (world.isClientSide) {
                world.levelEvent(player, 2001, pos, Block.getId((BlockState)removedState));
            } else {
                removedBlock.playerWillDestroy(world, pos, removedState, player);
            }
            if (world.setBlock(pos, newState, 11)) {
                removedBlock.destroy((LevelAccessor)world, pos, removedState);
            }
        }
        this.updateShapeCache(world, pos);
    }

    public long getExpandedShapeIndex(BlockState state, BlockGetter world, BlockPos pos) {
        long result = 0L;
        for (int side = 0; side < 6; ++side) {
            BooleanProperty attachmentSide = INTERIOR_FACES[side];
            if (!((Boolean)state.getValue((Property)attachmentSide)).booleanValue()) continue;
            result |= 1L << side;
            Direction attachmentDirection = Direction.from3DDataValue((int)side);
            for (int subSide = 0; subSide < 4; ++subSide) {
                int secondaryOrdinal = DirectionHelper.uncompressSecondSide(side, subSide);
                if (((Boolean)state.getValue((Property)INTERIOR_FACES[secondaryOrdinal])).booleanValue()) continue;
                Direction secondaryDir = Direction.from3DDataValue((int)secondaryOrdinal);
                Direction directionToWire = secondaryDir.getOpposite();
                BlockPos neighborPos = pos.relative(secondaryDir);
                BlockState neighborState = world.getBlockState(neighborPos);
                Block neighborBlock = neighborState.getBlock();
                if (!this.canAdjacentBlockConnectToFace(world, pos, state, neighborBlock, attachmentDirection, directionToWire, neighborPos, neighborState)) continue;
                result |= 1L << side * 4 + subSide + 6;
            }
        }
        return result |= this.getEdgeFlagsForNodeLineEdgeFormat(world, pos);
    }

    public VoxelShape getCachedExpandedShapeVoxel(BlockState wireState, Level world, BlockPos pos) {
        long index = this.getExpandedShapeIndex(wireState, (BlockGetter)world, pos);
        return (VoxelShape)this.voxelCache.getUnchecked((Object)index);
    }
}

