/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;

public abstract class RedstonePlateBlock
extends PlateBlock {
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;

    public RedstonePlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract InputSide[] getInputSides();

    public abstract EnumSet<Direction> getOutputSides(Level var1, BlockPos var2, BlockState var3);

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.hasInputPower(level, state, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = super.getStateForPlacement(context);
        for (InputSide side : this.getInputSides()) {
            state = (BlockState)state.setValue((Property)side.property, (Comparable)Boolean.valueOf(side.isBlockReceivingPower(world, state, pos)));
        }
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isPlayerHoldingStick = stack.is(Tags.Items.RODS_WOODEN);
        if (isPlayerHoldingStick && !level.isClientSide) {
            int newRotation = ((Integer)state.getValue((Property)ROTATION) + 1) % 4;
            BlockState newState = (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotation));
            for (InputSide side : this.getInputSides()) {
                newState = (BlockState)newState.setValue((Property)side.property, (Comparable)Boolean.valueOf(side.isBlockReceivingPower(level, newState, pos)));
            }
            level.setBlockAndUpdate(pos, newState);
        }
        return isPlayerHoldingStick ? ItemInteractionResult.SUCCESS : super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Deprecated
    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        if (side == null) {
            return false;
        }
        Direction primaryOutputDirection = PlateBlockStateProperties.getOutputDirection(state);
        if (side == primaryOutputDirection.getOpposite()) {
            return true;
        }
        Direction attachmentDirection = (Direction)state.getValue((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
        int baseRotation = (Integer)state.getValue((Property)PlateBlockStateProperties.ROTATION);
        for (InputSide inputSide : this.getInputSides()) {
            Direction inputDirection = BlockStateUtil.getInputDirection(attachmentDirection, baseRotation, inputSide.rotationsFromOutput);
            if (side != inputDirection.getOpposite()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.getSignal(blockAccess, pos, side);
    }

    @Deprecated
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, worldIn, pos, oldState, isMoving);
        this.notifyNeighbors(worldIn, pos, state);
    }

    @Deprecated
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.getBlock() != newState.getBlock()) {
            super.onRemove(state, worldIn, pos, newState, isMoving);
            this.notifyNeighbors(worldIn, pos, state);
        }
    }

    @Deprecated
    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        InputState oldInputState = InputState.getInput(state);
        InputState newInputState = InputState.getWorldPowerState(worldIn, state, pos);
        if (oldInputState != newInputState && !worldIn.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            worldIn.scheduleTick(pos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    public boolean hasInputPower(Level world, BlockState state, BlockPos pos) {
        for (InputSide side : this.getInputSides()) {
            if (!side.isBlockReceivingPower(world, state, pos)) continue;
            return true;
        }
        return false;
    }

    public void notifyNeighbors(Level level, BlockPos pos, BlockState state) {
        EnumSet<Direction> outputDirections = this.getOutputSides(level, pos, state);
        if (!EventHooks.onNeighborNotify((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), outputDirections, (boolean)false).isCanceled()) {
            for (Direction outputDirection : outputDirections) {
                BlockPos outputPos = pos.relative(outputDirection);
                level.neighborChanged(outputPos, (Block)this, pos);
                level.updateNeighborsAtExceptFromFacing(outputPos, (Block)this, outputDirection.getOpposite());
            }
        }
    }
}

