/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.integrateddynamics.api.network.INetworkIngredientsChannel;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class SlotCraftingAutoRefill
extends ResultSlot {
    private final CraftingContainer inventoryCrafting;
    private final TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon;
    private final TerminalStorageTabIngredientComponentServer<ItemStack, Integer> tabServer;
    private final ContainerTerminalStorageBase container;

    public SlotCraftingAutoRefill(Player player, CraftingContainer inventoryCrafting, Container inventoryIn, int slotIndex, int xPosition, int yPosition, TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon, TerminalStorageTabIngredientComponentServer<ItemStack, Integer> tabServer, ContainerTerminalStorageBase container) {
        super(player, inventoryCrafting, inventoryIn, slotIndex, xPosition, yPosition);
        this.inventoryCrafting = inventoryCrafting;
        this.tabCommon = tabCommon;
        this.tabServer = tabServer;
        this.container = container;
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType autoRefill = this.tabCommon.getAutoRefill();
        if (!thePlayer.level().isClientSide && autoRefill != TerminalButtonItemStackCraftingGridAutoRefill.AutoRefillType.DISABLED) {
            NonNullList<ItemStack> beforeCraft = SlotCraftingAutoRefill.inventoryToList((Container)this.inventoryCrafting, true);
            super.onTake(thePlayer, stack);
            NonNullList<ItemStack> afterCraft = SlotCraftingAutoRefill.inventoryToList((Container)this.inventoryCrafting, false);
            NonNullList<ItemStack> removed = SlotCraftingAutoRefill.getRemoved(beforeCraft, afterCraft);
            INetworkIngredientsChannel storage = this.tabServer.getIngredientNetwork().getChannel(this.container.getSelectedChannel());
            IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper player = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new PlayerInvWrapper(thePlayer.getInventory()));
            for (int i = 0; i < removed.size(); ++i) {
                ItemStack extracted;
                ItemStack removedStack = (ItemStack)removed.get(i);
                if (removedStack.isEmpty()) continue;
                switch (autoRefill) {
                    case STORAGE: {
                        extracted = (ItemStack)storage.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    case PLAYER: {
                        extracted = (ItemStack)player.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    case STORAGE_PLAYER: {
                        extracted = (ItemStack)storage.extract((Object)removedStack, (Object)13, false);
                        if (!extracted.isEmpty()) break;
                        extracted = (ItemStack)player.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    case PLAYER_STORAGE: {
                        extracted = (ItemStack)player.extract((Object)removedStack, (Object)13, false);
                        if (!extracted.isEmpty()) break;
                        extracted = (ItemStack)storage.extract((Object)removedStack, (Object)13, false);
                        break;
                    }
                    default: {
                        extracted = ItemStack.EMPTY;
                    }
                }
                thePlayer.containerMenu.broadcastChanges();
                ItemStack existingStack = this.inventoryCrafting.getItem(i);
                existingStack.grow(extracted.getCount());
                this.inventoryCrafting.setItem(i, existingStack);
                ((ServerPlayer)thePlayer).connection.send((Packet)new ClientboundContainerSetSlotPacket(thePlayer.containerMenu.containerId, thePlayer.containerMenu.getStateId(), i + this.index + 1, this.inventoryCrafting.getItem(i)));
            }
        } else {
            super.onTake(thePlayer, stack);
        }
    }

    public static NonNullList<ItemStack> inventoryToList(Container inventory, boolean copy) {
        NonNullList list = NonNullList.withSize((int)inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            list.set(i, (Object)(copy ? inventory.getItem(i).copy() : inventory.getItem(i)));
        }
        return list;
    }

    public static NonNullList<ItemStack> getRemoved(NonNullList<ItemStack> before, NonNullList<ItemStack> after) {
        NonNullList removed = NonNullList.withSize((int)before.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < before.size(); ++i) {
            ItemStack beforeStack = (ItemStack)before.get(i);
            ItemStack afterStack = (ItemStack)after.get(i);
            if (beforeStack.getCount() <= afterStack.getCount()) continue;
            beforeStack.setCount(beforeStack.getCount() - afterStack.getCount());
            removed.set(i, (Object)beforeStack);
        }
        return removed;
    }
}

