/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.data;

import dev.satherov.epitaphs.common.component.EPSoulboundAttachment;
import dev.satherov.epitaphs.compat.CompatHandler;
import dev.satherov.epitaphs.compat.CurioHandler;
import dev.satherov.epitaphs.core.EPRegistry;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class SoulboundHandler {
    public static void handleSoulbound(ServerPlayer player) {
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        NonNullList<ItemStack> soulboundItems = SoulboundHandler.extractSoulboundItems((NonNullList<ItemStack>)player.getInventory().items);
        NonNullList<ItemStack> soulboundArmor = SoulboundHandler.extractSoulboundItems((NonNullList<ItemStack>)player.getInventory().armor);
        NonNullList<ItemStack> soulboundOffhand = SoulboundHandler.extractSoulboundItems((NonNullList<ItemStack>)player.getInventory().offhand);
        NonNullList<ItemStack> soulboundCurios = SoulboundHandler.extractSoulboundItems((NonNullList<ItemStack>)CompatHandler.run("curios", () -> CurioHandler.getCurio(player), NonNullList.create()));
        attachment.setItems(player, soulboundItems);
        attachment.setArmor(player, soulboundArmor);
        attachment.setOffhand(player, soulboundOffhand);
        attachment.setCurio(player, soulboundCurios);
        for (ItemStack stack : soulboundCurios) {
            if (stack.isEmpty()) continue;
            CompatHandler.run("curios", () -> CurioHandler.removeCurio(player, stack));
        }
        player.setData(EPRegistry.SOULBOUND_DATA, (Object)attachment);
    }

    public static void restoreSoulbound(ServerPlayer player) {
        int experience;
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        SoulboundHandler.restoreItemsToSlots(player, (NonNullList<ItemStack>)player.getInventory().items, attachment.getItems());
        SoulboundHandler.restoreItemsToSlots(player, (NonNullList<ItemStack>)player.getInventory().armor, attachment.getArmor());
        SoulboundHandler.restoreItemsToSlots(player, (NonNullList<ItemStack>)player.getInventory().offhand, attachment.getOffhand());
        List<ItemStack> overFlow = CompatHandler.run("curios", () -> CurioHandler.setCurio(player, attachment.getCurio()), List.of());
        if (!overFlow.isEmpty()) {
            for (ItemStack stack : overFlow) {
                if (player.getInventory().add(stack)) continue;
                player.drop(stack, false);
            }
        }
        if ((experience = attachment.getExperience()) > 0) {
            player.giveExperiencePoints(experience);
        }
        ((EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA)).clear();
    }

    public static int handleXpSoulbound(ServerPlayer player) {
        EPSoulboundAttachment attachment = (EPSoulboundAttachment)player.getData(EPRegistry.SOULBOUND_DATA);
        NonNullList<ItemStack> armor = attachment.getArmor();
        int xpSoulboundCount = 0;
        for (ItemStack stack : armor) {
            if (stack.isEmpty() || !SoulboundHandler.hasXpSoulbound(stack)) continue;
            ++xpSoulboundCount;
        }
        return xpSoulboundCount;
    }

    private static NonNullList<ItemStack> extractSoulboundItems(NonNullList<ItemStack> originalList) {
        NonNullList soulboundItems = NonNullList.withSize((int)originalList.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < originalList.size(); ++i) {
            ItemStack stack = (ItemStack)originalList.get(i);
            if (!SoulboundHandler.hasSoulbound(stack)) continue;
            soulboundItems.set(i, (Object)stack.copy());
            originalList.set(i, (Object)ItemStack.EMPTY);
        }
        return soulboundItems;
    }

    private static void restoreItemsToSlots(ServerPlayer player, NonNullList<ItemStack> targetList, NonNullList<ItemStack> soulboundList) {
        for (int i = 0; i < Math.min(targetList.size(), soulboundList.size()); ++i) {
            ItemStack stack = (ItemStack)soulboundList.get(i);
            if (stack.isEmpty()) continue;
            if (((ItemStack)targetList.get(i)).isEmpty()) {
                targetList.set(i, (Object)stack);
                continue;
            }
            if (player.getInventory().add(stack)) continue;
            player.drop(stack, false);
        }
    }

    private static boolean hasSoulbound(ItemStack stack) {
        return EnchantmentHelper.has((ItemStack)stack, EPRegistry.SOULBOUND.get()) || EnchantmentHelper.has((ItemStack)stack, EPRegistry.EXPERIENCE_SOULBOUND.get());
    }

    private static boolean hasXpSoulbound(ItemStack stack) {
        return EnchantmentHelper.has((ItemStack)stack, EPRegistry.EXPERIENCE_SOULBOUND.get());
    }
}

