/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.data;

import dev.satherov.epitaphs.Epitaphs;
import dev.satherov.epitaphs.EpitaphsConfig;
import dev.satherov.epitaphs.client.lang.EPLanguage;
import dev.satherov.epitaphs.common.data.EBackupType;
import dev.satherov.epitaphs.compat.CompatHandler;
import dev.satherov.epitaphs.compat.CurioHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;

public class BackupHandler {
    private static final DateTimeFormatter TIMESTAMP_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").withZone(ZoneOffset.UTC);
    public static final Pattern DATE_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}");
    public static final Pattern FILE_PATTERN = Pattern.compile(DATE_PATTERN.pattern() + "-(?:death|save)\\.dat(?:-old)?$");
    private static final PathMatcher FILE_MATCHER = FileSystems.getDefault().getPathMatcher("regex:" + FILE_PATTERN.pattern());

    private static Path storageRoot(MinecraftServer server) {
        return server.getWorldPath(LevelResource.ROOT).normalize().toAbsolutePath().resolve("data").resolve("epitaphs");
    }

    private static Path playerDir(MinecraftServer server, UUID uuid) {
        return BackupHandler.storageRoot(server).resolve(uuid.toString());
    }

    private static void pruneBackups(Path dir, Pattern pattern, int keep) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, 1, new FileVisitOption[0]);){
            ArrayList<Path> files = new ArrayList<Path>(walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> pattern.matcher(path.getFileName().toString()).matches()).sorted(Comparator.naturalOrder()).toList());
            while (files.size() > keep) {
                Path file = (Path)files.removeFirst();
                Files.deleteIfExists(file);
                Epitaphs.LOGGER.debug("Removed old save file '{}'", (Object)file.getFileName());
            }
        }
    }

    public static LinkedList<String> listPlayers(MinecraftServer server) {
        return BackupHandler.listEntries(server, true, null);
    }

    public static LinkedList<String> listBackups(MinecraftServer server, String uuid) {
        return BackupHandler.listEntries(server, false, uuid);
    }

    private static LinkedList<String> listEntries(MinecraftServer server, boolean listPlayers, String uuid) {
        Object entityType3;
        block11: {
            Path target;
            if (server == null) {
                Epitaphs.LOGGER.error("Failed to list {} because server is unavailable.", (Object)(listPlayers ? "players" : "backups"));
                return new LinkedList<String>();
            }
            Path storage = BackupHandler.storageRoot(server);
            Path path = target = listPlayers ? storage : storage.resolve(uuid);
            if (!Files.exists(target, new LinkOption[0]) || !Files.isDirectory(target, new LinkOption[0])) {
                String entityType2 = listPlayers ? "backup directory" : "player directory";
                String identifier = listPlayers ? "storage" : uuid;
                Epitaphs.LOGGER.debug("No {} found for '{}'", (Object)entityType2, (Object)identifier);
                return new LinkedList<String>();
            }
            Stream<Path> walk = Files.walk(target, 1, new FileVisitOption[0]);
            try {
                LinkedList results = walk.filter(listPlayers ? x$0 -> Files.isDirectory(x$0, new LinkOption[0]) : x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(string -> listPlayers ? BackupHandler.isValidUuid(string) : FILE_PATTERN.matcher((CharSequence)string).matches()).sorted(Comparator.reverseOrder()).collect(Collectors.toCollection(LinkedList::new));
                if (results.isEmpty()) {
                    entityType3 = listPlayers ? "player directories" : "backup files";
                    String identifier = listPlayers ? "storage" : uuid;
                    Epitaphs.LOGGER.debug("No {} found for '{}'", entityType3, (Object)identifier);
                }
                entityType3 = results;
                if (walk == null) break block11;
            }
            catch (Throwable results) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable entityType3) {
                            results.addSuppressed(entityType3);
                        }
                    }
                    throw results;
                }
                catch (IOException e) {
                    String entityType4 = listPlayers ? "players" : "backups";
                    String identifier = listPlayers ? "storage" : uuid;
                    Epitaphs.LOGGER.error("Failed to list {} for '{}'", new Object[]{entityType4, identifier, e});
                    return new LinkedList<String>();
                }
            }
            walk.close();
        }
        return entityType3;
    }

    private static boolean isValidUuid(String string) {
        try {
            UUID.fromString(string);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static int save(ServerPlayer player, String timestamp, EBackupType type) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            Epitaphs.LOGGER.error("Failed to save data for player '{}' because server is unavailable", (Object)player.getScoreboardName());
            return -1;
        }
        Path storage = BackupHandler.playerDir(server, player.getUUID());
        CompoundTag tag = player.saveWithoutId(new CompoundTag());
        if (tag.isEmpty()) {
            Epitaphs.LOGGER.error("Player '{}' has no data", (Object)player.getScoreboardName());
            return -1;
        }
        try {
            Files.createDirectories(storage, new FileAttribute[0]);
            NbtIo.writeCompressed((CompoundTag)tag, (Path)storage.resolve(timestamp + "-" + type.getSerializedName() + ".dat"));
            if (type == EBackupType.DEATH) {
                CompatHandler.run("curios", () -> CurioHandler.clearCurio(player));
                player.getInventory().clearContent();
            }
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("Failed to write data for player '{}' to disk", (Object)player.getScoreboardName(), (Object)e);
            return -1;
        }
        Pattern pattern = switch (type) {
            default -> throw new MatchException(null, null);
            case EBackupType.DEATH -> Pattern.compile(DATE_PATTERN.pattern() + "-death\\.dat-old");
            case EBackupType.SAVE -> Pattern.compile(DATE_PATTERN.pattern() + "-save\\.dat(?:-old)?$");
        };
        try {
            int limit = type == EBackupType.SAVE ? EpitaphsConfig.getMaxBackups() : EpitaphsConfig.getMaxOld();
            BackupHandler.pruneBackups(storage, pattern, limit);
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("Failed to clean up old saves for player '{}'", (Object)player.getScoreboardName(), (Object)e);
            return -1;
        }
        return 0;
    }

    public static boolean saveAll(MinecraftServer server) {
        Path storage = BackupHandler.storageRoot(server);
        Pattern pattern = Pattern.compile(DATE_PATTERN.pattern() + "-save\\.dat(?:-old)?$");
        List players = server.getPlayerList().getPlayers();
        if (players.isEmpty()) {
            Epitaphs.LOGGER.info("No players found, skipping save");
            return false;
        }
        for (ServerPlayer player : players) {
            Path target = storage.resolve(player.getUUID().toString());
            CompoundTag tag = player.saveWithoutId(new CompoundTag());
            try {
                Files.createDirectories(target, new FileAttribute[0]);
                String timestamp = TIMESTAMP_FMT.format(Instant.now());
                NbtIo.writeCompressed((CompoundTag)tag, (Path)target.resolve(timestamp + "-save.dat"));
            }
            catch (IOException e) {
                Epitaphs.LOGGER.error("Failed to write data for player '{}' to disk", (Object)player.getScoreboardName(), (Object)e);
            }
        }
        try (Stream<Path> walk = Files.walk(storage, 1, new FileVisitOption[0]);){
            for (ServerPlayer player : players) {
                Path dir = storage.resolve(player.getUUID().toString());
                if (!Files.exists(dir, new LinkOption[0])) continue;
                BackupHandler.pruneBackups(dir, pattern, EpitaphsConfig.getMaxBackups());
            }
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("Failed to clean up old saves", (Throwable)e);
            return false;
        }
        return true;
    }

    public static CompoundTag load(MinecraftServer server, String uuid, String timestamp) {
        Path file;
        CompoundTag data = new CompoundTag();
        if (server == null) {
            Epitaphs.LOGGER.error("Failed to load data for player with uuid '{}' because server is unavailable", (Object)uuid);
            return data;
        }
        if (timestamp.isBlank() || !DATE_PATTERN.matcher(timestamp).matches() && !FILE_PATTERN.matcher(timestamp).matches()) {
            Epitaphs.LOGGER.error("Invalid backup timestamp '{}'", (Object)timestamp);
            return data;
        }
        Path target = BackupHandler.playerDir(server, UUID.fromString(uuid));
        if (!Files.exists(target, new LinkOption[0]) || !Files.isDirectory(target, new LinkOption[0])) {
            Epitaphs.LOGGER.debug("No backup directory found for uuid '{}'", (Object)uuid);
            return data;
        }
        try (Stream<Path> files = Files.list(target);){
            file = files.filter(p -> FILE_MATCHER.matches(p.getFileName()) && p.getFileName().toString().startsWith(timestamp)).findFirst().orElse(null);
            if (file == null) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("No backup file found for uuid '{}' at '{}'", (Object)uuid, (Object)timestamp);
            return data;
        }
        try {
            data = NbtIo.readCompressed((Path)file, (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (data.isEmpty()) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("Failed to read file '{}'", (Object)file.getFileName(), (Object)e);
        }
        return data;
    }

    public static int restore(ServerPlayer player, String uuid, String timestamp, boolean clear) {
        CompoundTag data = BackupHandler.load(player.getServer(), uuid, timestamp);
        if (data.isEmpty()) {
            Epitaphs.LOGGER.warn("Cannot restore uuid '{}' because data is empty", (Object)uuid);
            return -1;
        }
        return BackupHandler.restoreOnline(player, data, clear);
    }

    public static int restoreCommand(MinecraftServer server, CommandSourceStack source, String uuid, String timestamp, boolean clear) {
        CompoundTag data = BackupHandler.load(server, uuid, timestamp);
        if (data.isEmpty()) {
            Epitaphs.LOGGER.warn("Cannot restore uuid '{}' because data is empty", (Object)uuid);
            return -1;
        }
        ServerPlayer player = server.getPlayerList().getPlayer(UUID.fromString(uuid));
        if (player != null) {
            Epitaphs.LOGGER.debug("Restoring data for player '{}'", (Object)player.getScoreboardName());
            return BackupHandler.restoreOnline(player, data, clear);
        }
        Epitaphs.LOGGER.debug("Restoring data for offline player '{}'", (Object)uuid);
        return BackupHandler.restoreOffline(server, source, uuid, data, clear);
    }

    private static int restoreOnline(ServerPlayer player, CompoundTag data, boolean clear) {
        ItemStack stack2;
        int i;
        ListTag inventory = data.getList("Inventory", 10);
        if (clear) {
            player.getInventory().clearContent();
        }
        CompatHandler.run("curios", () -> CurioHandler.loadInventory(player, data, clear));
        if (BackupHandler.quickLoad(player, inventory)) {
            return 0;
        }
        ArrayList<ItemStack> overflow = new ArrayList<ItemStack>();
        NonNullList items = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        NonNullList armor = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        NonNullList offhand = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        for (i = 0; i < inventory.size(); ++i) {
            CompoundTag tag = inventory.getCompound(i);
            int j = tag.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.parse((HolderLookup.Provider)player.registryAccess(), (Tag)tag).orElse(ItemStack.EMPTY);
            if (j < items.size()) {
                items.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < armor.size() + 100) {
                armor.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= offhand.size() + 150) continue;
            offhand.set(j - 150, (Object)itemstack);
        }
        for (i = 0; i < player.getInventory().items.size(); ++i) {
            stack2 = (ItemStack)items.get(i);
            if (stack2.isEmpty()) continue;
            if (((ItemStack)player.getInventory().items.get(i)).isEmpty()) {
                player.getInventory().items.set(i, (Object)stack2);
                continue;
            }
            overflow.add(stack2);
        }
        for (i = 0; i < player.getInventory().armor.size(); ++i) {
            stack2 = (ItemStack)armor.get(i);
            if (stack2.isEmpty()) continue;
            if (((ItemStack)player.getInventory().armor.get(i)).isEmpty()) {
                player.getInventory().armor.set(i, (Object)stack2);
                continue;
            }
            overflow.add(stack2);
        }
        for (i = 0; i < player.getInventory().offhand.size(); ++i) {
            stack2 = (ItemStack)offhand.get(i);
            if (stack2.isEmpty()) continue;
            if (((ItemStack)player.getInventory().offhand.get(i)).isEmpty()) {
                player.getInventory().offhand.set(i, (Object)stack2);
                continue;
            }
            overflow.add(stack2);
        }
        for (ItemStack stack2 : overflow) {
            ItemEntity item;
            if (player.getInventory().add(stack2) || (item = player.drop(stack2, false)) == null) continue;
            item.setNoPickUpDelay();
        }
        return 0;
    }

    private static int restoreOffline(MinecraftServer server, CommandSourceStack source, String uuid, CompoundTag data, boolean clear) {
        int i;
        ListTag rootInventory;
        File directory = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).toFile();
        File file = new File(directory, uuid + ".dat");
        CompoundTag root = new CompoundTag();
        if (file.exists() && file.isFile()) {
            try {
                root = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (Exception exception) {
                Epitaphs.LOGGER.warn("Failed to access playerdata for uuid '{}'", (Object)uuid);
                return -1;
            }
        }
        if (clear) {
            root.remove("Inventory");
            rootInventory = new ListTag();
            root.put("Inventory", (Tag)rootInventory);
        } else {
            rootInventory = root.getList("Inventory", 10);
        }
        ListTag inventory = data.getList("Inventory", 10);
        ArrayList<Object> failedInserts = new ArrayList<Object>();
        HashSet<Integer> occupied = new HashSet<Integer>();
        for (i = 0; i < rootInventory.size(); ++i) {
            CompoundTag existing = rootInventory.getCompound(i);
            int n = existing.getByte("Slot") & 0xFF;
            occupied.add(n);
        }
        for (i = 0; i < inventory.size(); ++i) {
            CompoundTag itemTag = inventory.getCompound(i);
            int n = itemTag.getByte("Slot") & 0xFF;
            if (!occupied.contains(n)) {
                rootInventory.add((Object)itemTag);
                occupied.add(n);
                continue;
            }
            failedInserts.add(itemTag);
        }
        ArrayList<CompoundTag> failed = new ArrayList<CompoundTag>();
        for (CompoundTag compoundTag : failedInserts) {
            boolean inserted = false;
            for (int slot2 = 0; slot2 < 36; ++slot2) {
                if (occupied.contains(slot2)) continue;
                CompoundTag newItemTag = compoundTag.copy();
                newItemTag.putByte("Slot", (byte)slot2);
                rootInventory.add((Object)newItemTag);
                occupied.add(slot2);
                inserted = true;
                break;
            }
            if (inserted) continue;
            failed.add(compoundTag);
        }
        if (!failed.isEmpty()) {
            Epitaphs.LOGGER.warn("Could not insert {} items for uuid '{}' - no empty slots available:", (Object)failed.size(), (Object)uuid);
            if (source != null && source.isPlayer()) {
                ServerPlayer player = source.getPlayer();
                source.sendSystemMessage((Component)EPLanguage.COMMAND_RESTORE_OVERFLOW.translate(uuid).withStyle(ChatFormatting.RED));
                for (CompoundTag tag : failed) {
                    ItemStack stack = ItemStack.parse((HolderLookup.Provider)server.registryAccess(), (Tag)tag).orElse(ItemStack.EMPTY);
                    if (stack.isEmpty() || player.getInventory().add(stack)) continue;
                    player.drop(stack, false);
                }
            } else {
                Epitaphs.LOGGER.error("The following items were lost:");
                for (CompoundTag compoundTag : failed) {
                    int slot3 = compoundTag.getByte("Slot") & 0xFF;
                    String item = compoundTag.getString("id");
                    byte count = compoundTag.getByte("count");
                    Epitaphs.LOGGER.warn(" - {} x{} (slot: {})", new Object[]{item, (int)count, slot3});
                }
            }
        }
        try {
            NbtIo.writeCompressed((CompoundTag)root, (Path)file.toPath());
            Epitaphs.LOGGER.debug("Successfully restored items for uuid '{}'", (Object)uuid);
        }
        catch (IOException e) {
            Epitaphs.LOGGER.error("Failed to write updated playerdata for uuid '{}'", (Object)uuid, (Object)e);
            return -1;
        }
        return 0;
    }

    private static boolean quickLoad(ServerPlayer player, ListTag data) {
        if (player.getInventory().isEmpty()) {
            player.getInventory().load(data);
            return true;
        }
        return false;
    }

    public static List<ItemStack> getContents(MinecraftServer server, String uuid, String timeStamp) {
        return BackupHandler.getContents(server, BackupHandler.load(server, uuid, timeStamp));
    }

    public static List<ItemStack> getContents(MinecraftServer server, CompoundTag root) {
        ListTag data = root.getList("Inventory", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < data.size(); ++i) {
            CompoundTag tag = data.getCompound(i);
            ItemStack itemstack = ItemStack.parse((HolderLookup.Provider)server.registryAccess(), (Tag)tag).orElse(ItemStack.EMPTY);
            stacks.add(itemstack);
        }
        stacks.addAll(CompatHandler.run("curios", () -> CurioHandler.loadContents(server, root), List.of()));
        return stacks;
    }
}

