/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.component;

import dev.satherov.epitaphs.core.EPRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class EPLocationAttachment
implements INBTSerializable<ListTag> {
    private final Map<String, List<Map.Entry<String, BlockPos>>> graveLocations = new HashMap<String, List<Map.Entry<String, BlockPos>>>();

    public Map<String, List<Map.Entry<String, BlockPos>>> getGraveLocations(ServerLevel level) {
        this.clearMissing(level);
        return this.graveLocations;
    }

    public EPLocationAttachment addGraveLocation(ServerPlayer player, String timestamp, BlockPos pos) {
        this.graveLocations.computeIfAbsent(player.level().dimension().location().toString(), k -> new ArrayList()).add(new AbstractMap.SimpleEntry<String, BlockPos>(timestamp, pos.immutable()));
        this.clearMissing(player.serverLevel());
        return this;
    }

    public EPLocationAttachment removeGraveLocation(String timestamp, ResourceKey<Level> dimension, BlockPos pos) {
        this.graveLocations.computeIfAbsent(dimension.location().toString(), k -> new ArrayList()).removeIf(entry -> ((String)entry.getKey()).equals(timestamp) && ((BlockPos)entry.getValue()).equals((Object)pos.immutable()));
        return this;
    }

    public EPLocationAttachment removeGraveLocation(ServerPlayer player, String timestamp, BlockPos pos) {
        this.removeGraveLocation(timestamp, (ResourceKey<Level>)player.level().dimension(), pos);
        this.clearMissing(player.serverLevel());
        return this;
    }

    public Optional<GlobalPos> findLatestGraveLocation(ServerLevel level) {
        this.clearMissing(level);
        return this.graveLocations.entrySet().stream().flatMap(dimension -> ((List)dimension.getValue()).stream().map(entry -> new AbstractMap.SimpleEntry<String, GlobalPos>((String)entry.getKey(), GlobalPos.of((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)((String)dimension.getKey()))), (BlockPos)((BlockPos)entry.getValue()))))).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue);
    }

    private void clearMissing(ServerLevel level) {
        this.graveLocations.entrySet().removeIf(dimensionEntry -> {
            if (!level.dimension().location().equals((Object)ResourceLocation.parse((String)((String)dimensionEntry.getKey())))) {
                return false;
            }
            List list = (List)dimensionEntry.getValue();
            list.removeIf(entry -> {
                BlockPos pos = (BlockPos)entry.getValue();
                return level.isLoaded(pos) && !level.getBlockState(pos).is((Block)EPRegistry.GRAVE.get());
            });
            return list.isEmpty();
        });
    }

    public @UnknownNullability ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag dimensions = new ListTag();
        this.graveLocations.forEach((key, value) -> {
            CompoundTag dimension = new CompoundTag();
            ListTag positions = new ListTag();
            value.forEach(entry -> {
                CompoundTag tag = new CompoundTag();
                tag.putString("timestamp", (String)entry.getKey());
                tag.putLong("position", ((BlockPos)entry.getValue()).asLong());
                positions.add((Object)tag);
            });
            dimension.put(key, (Tag)positions);
            dimensions.add((Object)dimension);
        });
        return dimensions;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag nbt) {
        HashMap graveLocations = new HashMap();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.getCompound(i);
            tag.getAllKeys().forEach(dimension -> {
                ListTag positions = tag.getList(dimension, 10);
                ArrayList<AbstractMap.SimpleEntry<String, BlockPos>> entries = new ArrayList<AbstractMap.SimpleEntry<String, BlockPos>>();
                for (int j = 0; j < positions.size(); ++j) {
                    CompoundTag position = positions.getCompound(j);
                    entries.add(new AbstractMap.SimpleEntry<String, BlockPos>(position.getString("timestamp"), BlockPos.of((long)position.getLong("position"))));
                }
                graveLocations.put(dimension, entries);
            });
        }
        this.graveLocations.putAll(graveLocations);
    }
}

