/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.component;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class EPGraveDataAttachment
implements INBTSerializable<CompoundTag> {
    String timestamp = "";
    String owner = "";
    List<ItemStack> additional = new ArrayList<ItemStack>();

    public EPGraveDataAttachment create(ServerPlayer player, String timestamp) {
        this.timestamp = timestamp;
        this.owner = player.getStringUUID();
        return this;
    }

    public void saveAdditional(List<ItemStack> additional) {
        this.additional = additional;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<ItemStack> getAdditional() {
        return this.additional;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag data = new CompoundTag();
        data.putString("uuid", this.owner);
        data.putString("timestamp", this.timestamp);
        ListTag stacks = new ListTag();
        for (ItemStack stack : this.additional) {
            if (stack.isEmpty()) continue;
            stacks.add((Object)stack.save(provider, (Tag)new CompoundTag()));
        }
        if (!stacks.isEmpty()) {
            data.put("additional", (Tag)stacks);
        }
        return data;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.owner = nbt.getString("uuid");
        this.timestamp = nbt.getString("timestamp");
        ArrayList<ItemStack> additional = new ArrayList<ItemStack>();
        if (nbt.contains("additional")) {
            ListTag stacks = nbt.getList("additional", 10);
            for (int i = 0; i < stacks.size(); ++i) {
                CompoundTag tag = stacks.getCompound(i);
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
                if (stack.isEmpty()) continue;
                additional.add(stack);
            }
        }
        this.additional = additional;
    }
}

