/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.epitaphs.common.command.suggestion;

import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class EPSuggestions
extends Suggestions {
    private static final EPSuggestions EMPTY = new EPSuggestions(StringRange.at((int)0), new ArrayList<Suggestion>());

    public EPSuggestions(StringRange range, List<Suggestion> suggestions) {
        super(range, suggestions);
    }

    public EPSuggestions reverse() {
        ArrayList<Suggestion> reversedSuggestions = new ArrayList<Suggestion>(this.getList());
        Collections.reverse(reversedSuggestions);
        return new EPSuggestions(this.getRange(), reversedSuggestions);
    }

    public static EPSuggestions create(String command, Collection<Suggestion> suggestions) {
        if (suggestions.isEmpty()) {
            return new EPSuggestions(StringRange.at((int)0), new ArrayList<Suggestion>());
        }
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Suggestion suggestion : suggestions) {
            start = Math.min(suggestion.getRange().getStart(), start);
            end = Math.max(suggestion.getRange().getEnd(), end);
        }
        StringRange range = new StringRange(start, end);
        HashSet<Suggestion> texts = new HashSet<Suggestion>();
        for (Suggestion suggestion : suggestions) {
            texts.add(suggestion.expand(command, range));
        }
        ArrayList<Suggestion> sorted = new ArrayList<Suggestion>(texts);
        sorted.sort(Suggestion::compareToIgnoreCase);
        return new EPSuggestions(range, sorted);
    }
}

