/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.jei.FusionRecipeTransferHelper;
import com.brandon3055.draconicevolution.inventory.ConfigurableItemMenu;
import com.brandon3055.draconicevolution.inventory.FusionCraftingCoreMenu;
import com.brandon3055.draconicevolution.inventory.ModularItemMenu;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.brandon3055.draconicevolution.items.tools.Magnet;
import com.brandon3055.draconicevolution.network.InputSync;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;

public class ServerPacketHandler
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayer sender) {
        switch (packet.getType()) {
            case 1: {
                this.toggleDislocators((Player)sender);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.moduleSlotClick((Player)sender, (MCDataInput)packet);
                break;
            }
            case 12: {
                this.moduleEntityMessage((Player)sender, (MCDataInput)packet);
                break;
            }
            case 6: {
                this.propertyData(sender, packet);
                break;
            }
            case 7: {
                if (packet.readBoolean()) {
                    ModularItemMenu.tryOpenGui(sender);
                    break;
                }
                ConfigurableItemMenu.tryOpenGui(sender);
                break;
            }
            case 8: {
                ModularItemMenu.tryOpenGui(sender);
                break;
            }
            case 9: {
                this.dislocatorMessage(sender, packet);
                break;
            }
            case 14: {
                this.dislocatorScroll(sender, packet);
                break;
            }
            case 10: {
                this.jeiFusionTransfer(sender, packet);
                break;
            }
            case 11: {
                this.placeItem(sender, packet);
                break;
            }
            case 13: {
                InputSync.setSprintState(sender.getUUID(), packet.readBoolean());
            }
        }
    }

    private void toggleDislocators(Player player) {
        ArrayList<ItemStack> dislocators = new ArrayList<ItemStack>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof Magnet)) continue;
            dislocators.add(stack);
        }
        for (ItemStack stack : EquipmentManager.getAllItems((LivingEntity)player)) {
            if (!(stack.getItem() instanceof Magnet)) continue;
            dislocators.add(stack);
        }
        for (ItemStack stack : dislocators) {
            Magnet.toggleEnabled(stack, player);
            boolean enabled = Magnet.isEnabled(stack);
            player.displayClientMessage((Component)Component.translatable((String)("item_dislocate.draconicevolution." + (enabled ? "activate" : "deactivate"))).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED), true);
        }
    }

    private void moduleSlotClick(Player player, MCDataInput input) {
        ModuleHostContainer container;
        ModuleGrid grid;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ModuleHostContainer && (grid = (container = (ModuleHostContainer)abstractContainerMenu).getGrid()) != null) {
            try (ModuleHost host = container.getModuleHost();){
                ModuleGrid.GridPos pos = grid.getCell(host, input.readByte(), input.readByte());
                grid.cellClicked(host, pos, input.readFloat(), input.readFloat(), input.readByte(), (ClickType)input.readEnum(ClickType.class));
            }
        }
    }

    private void moduleEntityMessage(Player player, MCDataInput input) {
        ModuleHostContainer container;
        ModuleGrid grid;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ModuleHostContainer && (grid = (container = (ModuleHostContainer)abstractContainerMenu).getGrid()) != null) {
            try (ModuleHost host = container.getModuleHost();){
                ModuleGrid.GridPos pos = grid.getCell(host, input.readByte(), input.readByte());
                if (pos.hasEntity()) {
                    pos.getEntity().handleClientMessage(input);
                }
            }
        }
    }

    private void propertyData(ServerPlayer sender, PacketCustom packet) {
        PropertyData data = PropertyData.read((MCDataInput)packet);
        ConfigurableItemMenu.handlePropertyData((Player)sender, data);
    }

    private void dislocatorMessage(ServerPlayer sender, PacketCustom packet) {
        ItemStack stack = DislocatorAdvanced.findDislocator((Player)sender);
        if (!stack.isEmpty()) {
            ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).handleClientAction(sender, stack, (MCDataInput)packet);
        }
    }

    private void dislocatorScroll(ServerPlayer sender, PacketCustom packet) {
        ItemStack stack = DislocatorAdvanced.findDislocator((Player)sender);
        if (!stack.isEmpty()) {
            ((DislocatorAdvanced)((Object)DEContent.DISLOCATOR_ADVANCED.get())).scrollSelected(sender, stack, packet.readByte());
        }
    }

    private void jeiFusionTransfer(ServerPlayer sender, PacketCustom packet) {
        Recipe recipe;
        ResourceLocation id = packet.readResourceLocation();
        boolean maxTransfer = packet.readBoolean();
        RecipeHolder recipe2 = sender.level().getRecipeManager().byKey(id).orElse(null);
        if (recipe2 != null && (recipe = recipe2.value()) instanceof IFusionRecipe) {
            IFusionRecipe fusionRecipe = (IFusionRecipe)recipe;
            if (sender.containerMenu instanceof FusionCraftingCoreMenu) {
                FusionRecipeTransferHelper.doServerSideTransfer(sender, (FusionCraftingCoreMenu)sender.containerMenu, fusionRecipe, maxTransfer);
            }
        }
    }

    private void placeItem(ServerPlayer player, PacketCustom packet) {
        ItemStack stack = HandHelper.getMainFirst((Player)player);
        if (stack.isEmpty()) {
            return;
        }
        HitResult traceResult = player.pick(5.0, 0.0f, false);
        if (traceResult.getType() == HitResult.Type.BLOCK) {
            Level level = player.level();
            BlockHitResult blockTrace = (BlockHitResult)traceResult;
            BlockPos posHit = blockTrace.getBlockPos();
            if (!com.brandon3055.brandonscore.network.ServerPacketHandler.verifyPlayerPermission((Player)player, (BlockPos)posHit)) {
                return;
            }
            BlockEntity tileHit = level.getBlockEntity(posHit);
            BlockPos posOnSide = posHit.relative(blockTrace.getDirection());
            BlockEntity tileOnSide = level.getBlockEntity(posOnSide);
            if (tileHit instanceof TilePlacedItem && InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileHit).itemHandler, (ItemStack)stack, (boolean)true).isEmpty()) {
                InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileHit).itemHandler, (ItemStack)stack, (boolean)false);
                player.getInventory().removeItem(stack);
            } else if (tileOnSide instanceof TilePlacedItem && InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileOnSide).itemHandler, (ItemStack)stack, (boolean)true).isEmpty()) {
                InventoryUtils.insertItem((IItemHandler)((TilePlacedItem)tileOnSide).itemHandler, (ItemStack)stack, (boolean)false);
                player.getInventory().removeItem(stack);
            } else if (level.isEmptyBlock(posOnSide) && !EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)posHit), (Direction)blockTrace.getDirection())) {
                level.setBlockAndUpdate(posOnSide, (BlockState)((PlacedItem)((Object)DEContent.PLACED_ITEM.get())).defaultBlockState().setValue((Property)PlacedItem.FACING, (Comparable)blockTrace.getDirection()));
                BlockEntity tile = level.getBlockEntity(posOnSide);
                if (tile instanceof TilePlacedItem) {
                    ((TilePlacedItem)tile).itemHandler.setStackInSlot(0, stack);
                    player.getInventory().removeItem(stack);
                }
            }
        }
    }
}

