/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.ItemData;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;

public class MobSoul
extends Item {
    private static final Map<ResourceLocation, Entity> renderEntityMap = new HashMap<ResourceLocation, Entity>();
    public static List<ResourceLocation> randomDisplayList = null;

    public MobSoul(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(context.getHand());
        if (player.isShiftKeyDown()) {
            Entity entity = this.createEntity(level, stack);
            double sX = (double)(pos.getX() + facing.getStepX()) + 0.5;
            double sY = (double)(pos.getY() + facing.getStepY()) + 0.5;
            double sZ = (double)(pos.getZ() + facing.getStepZ()) + 0.5;
            if (entity == null) {
                LogHelper.error("Mob Soul bound entity = null");
                return super.useOn(context);
            }
            entity.moveTo(sX, sY, sZ, player.getYRot(), 0.0f);
            if (!level.isClientSide) {
                if (!stack.has(ItemData.SOUL_DATA) && entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(new BlockPos(0, 0, 0)), (MobSpawnType)MobSpawnType.SPAWN_EGG, null);
                    }
                }
                level.addFreshEntity(entity);
                if (!player.getAbilities().instabuild) {
                    InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)context.getHand());
                }
            }
        }
        return super.useOn(context);
    }

    public Component getName(ItemStack stack) {
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.getEntity(stack));
        return Component.translatable((String)type.getDescriptionId()).append(" ").append(super.getName(stack));
    }

    public ResourceLocation getEntity(ItemStack stack) {
        return (ResourceLocation)stack.getOrDefault(ItemData.SOUL_ID, (Object)ResourceLocation.withDefaultNamespace((String)"pig"));
    }

    public void setEntity(ResourceLocation entityName, ItemStack stack) {
        stack.set(ItemData.SOUL_ID, (Object)entityName);
    }

    @Nullable
    public CompoundTag getEntityData(ItemStack stack) {
        CustomData data = (CustomData)stack.get(ItemData.SOUL_DATA);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return data.copyTag();
    }

    public void setEntityData(CompoundTag compound, ItemStack stack) {
        compound.remove("UUID");
        compound.remove("Motion");
        stack.set(ItemData.SOUL_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    public Entity createEntity(Level level, ItemStack stack) {
        try {
            CompoundTag entityData = this.getEntityData(stack);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.getEntity(stack));
            Entity entity = type.create(level);
            if (entity == null) {
                return EntityType.PIG.create(level);
            }
            if (entityData != null) {
                entity.load(entityData);
            } else if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(new BlockPos(0, 0, 0)), (MobSpawnType)MobSpawnType.SPAWN_EGG, null);
                }
            }
            return entity;
        }
        catch (Throwable e) {
            return EntityType.PIG.create(level);
        }
    }

    public ItemStack getSoulFromEntity(Entity entity, boolean saveEntityData) {
        ItemStack soul = new ItemStack((ItemLike)DEContent.MOB_SOUL.get());
        this.setEntity(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), soul);
        if (saveEntityData) {
            CompoundTag compound = new CompoundTag();
            entity.saveWithoutId(compound);
            this.setEntityData(compound, soul);
        }
        return soul;
    }

    public Entity getRenderEntity(ItemStack stack) {
        return this.getRenderEntity(this.getEntity(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getRenderEntity(ResourceLocation name) {
        if (name == null || name.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"random_display_entity"))) {
            if (randomDisplayList == null) {
                randomDisplayList = new ArrayList<ResourceLocation>();
                SpawnEggItem.BY_ID.keySet().forEach(type -> randomDisplayList.add(BuiltInRegistries.ENTITY_TYPE.getKey(type)));
            }
            if (!randomDisplayList.isEmpty()) {
                name = randomDisplayList.get(TimeKeeper.getClientTick() / 20 % randomDisplayList.size());
            }
        }
        if (!renderEntityMap.containsKey(name)) {
            Entity entity;
            ClientLevel level = Minecraft.getInstance().level;
            try {
                EntityType type2 = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(name);
                entity = type2.create((Level)level);
                if (entity == null) {
                    entity = EntityType.PIG.create((Level)level);
                }
            }
            catch (Throwable e) {
                entity = EntityType.PIG.create((Level)level);
            }
            renderEntityMap.put(name, entity);
        }
        return renderEntityMap.get(name);
    }
}

