/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiContextMenu;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiScrolling;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Position;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ItemConfigDataHandler;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyContainer;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyElement;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.inventory.ConfigurableItemMenu;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConfigurableItemGui
extends ContainerGuiProvider<ConfigurableItemMenu> {
    public static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.item_config");
    private static final int MINIMIZE_HEIGHT = 15;
    private static final int NORMAL_HEIGHT = 230;
    private static final int ADVANCED_HEIGHT = 97;
    private static List<PropertyContainer> keyBindCache = null;
    public boolean advancedUI = false;
    private boolean minimize = false;
    private boolean cancelAutoPos = false;
    private boolean closeOnRelease = false;
    private boolean bindReleased = false;
    private int holdTimer = 0;
    private double minimizeAnim = 0.0;
    private double positionAnim = 1.0;
    private double resizeAnim = 1.0;
    protected ModularGui gui;
    protected GuiTexture mainUI;
    protected GuiElement<?> root;
    protected UUID selectedItem = null;
    protected ConfigurableItemMenu menu;
    protected ContainerScreenAccess<ConfigurableItemMenu> screenAccess;
    protected List<PropertyContainer> propertyContainers = new ArrayList<PropertyContainer>();
    protected GuiScrolling simpleUIScroll;
    protected GuiElement<?> deleteZone;
    protected PropertyData hoveredData = null;
    protected PropertyProvider hoveredProvider = null;
    protected List<UpdateAnim> updateAnimations = new ArrayList<UpdateAnim>();
    private static Map<InputConstants.Key, Integer> MULTI_BIND_INDEX_MAP = new HashMap<InputConstants.Key, Integer>();

    public void buildGui(ModularGui gui, ContainerScreenAccess<ConfigurableItemMenu> screenAccess) {
        this.gui = gui;
        this.screenAccess = screenAccess;
        gui.initFullscreenGui();
        this.menu = (ConfigurableItemMenu)screenAccess.getMenu();
        this.root = gui.getRoot();
        this.mainUI = ((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture(this.root, BCGuiTextures.themedGetter((String)"background_dynamic")).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)218.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> MathHelper.interpolate((double)97.0, (double)230.0, (double)this.resizeAnim)))).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)this.root.get(GeoParam.LEFT), (GeoRef)this.root.get(GeoParam.RIGHT), (double)-109.0))).dynamicTexture();
        Supplier<Double> normalPos = () -> this.root.yCenter() - 115.0;
        Supplier<Double> advancedPos = () -> this.root.yMax() - MathHelper.interpolate((double)97.0, (double)15.0, (double)this.minimizeAnim);
        this.mainUI.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> MathHelper.interpolate((double)((Double)advancedPos.get()), (double)((Double)normalPos.get()), (double)this.positionAnim)));
        ButtonRow leftButtons = ButtonRow.topLeftInside((GuiElement)this.mainUI, (Direction)Direction.RIGHT, (int)3, (int)3).setSpacing(1.0);
        leftButtons.addButton(e -> (GuiElement)TOOLKIT.createThemedIconButton((GuiParent)e, "advanced").onPress(() -> {
            this.advancedUI = !this.advancedUI;
        }).setTooltip(new Component[]{TOOLKIT.translate("toggle_advanced.info", new Object[0])}));
        leftButtons.addButton(e -> (GuiElement)((GuiButton)TOOLKIT.createThemedIconButton((GuiParent)e, "gear").onPress(this::openOptionsDialog).setEnabled(() -> this.advancedUI)).setTooltip(new Component[]{TOOLKIT.translate("options", new Object[0])}));
        leftButtons.addButton(e -> (GuiElement)TOOLKIT.createThemedIconButton((GuiParent)e, "hud_button").onPress(() -> gui.mc().setScreen((net.minecraft.client.gui.screens.Screen)new HudConfigGui.Screen())).setTooltip(new Component[]{Component.translatable((String)"hud.draconicevolution.open_hud_config")}));
        ButtonRow rightButtons = ButtonRow.topRightInside((GuiElement)this.mainUI, (Direction)Direction.LEFT, (int)3, (int)3).setSpacing(1.0);
        rightButtons.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        rightButtons.addButton(e -> (GuiElement)((GuiButton)TOOLKIT.createResizeButton((GuiParent)e).setEnabled(() -> this.advancedUI)).onPress(() -> {
            this.minimize = !this.minimize;
        }).setTooltip(new Component[]{TOOLKIT.translate("toggle_hidden.info", new Object[0])}));
        rightButtons.addButton(e -> (GuiElement)TOOLKIT.createThemedIconButton((GuiParent)e, "grid_small").onPress(this::openModulesGui).setTooltip(new Component[]{TOOLKIT.translate("open_modules.info", new Object[0])}));
        GuiText title = (GuiText)((GuiText)TOOLKIT.createHeading((GuiParent)this.mainUI, gui.getGuiTitle(), true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)leftButtons.get(GeoParam.RIGHT), (double)1.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)rightButtons.get(GeoParam.LEFT)));
        title.setTextSupplier(() -> this.getGuiTitle(this.menu, (GuiElement<?>)title));
        GuiSlots.PlayerAll playInv = GuiSlots.playerAllSlots((GuiParent)this.mainUI, screenAccess, (SlotGroup)this.menu.main, (SlotGroup)this.menu.hotBar, (SlotGroup)this.menu.armor, (SlotGroup)this.menu.offhand);
        playInv.stream().forEach(e -> e.setSlotOverlay(this::renderSlotOverlay).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)this.mainUI, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        this.setupCurioSlots();
        this.setupSimpleUI(playInv.container());
        this.setupAdvancedUI();
        this.selectedItem = this.menu.getSelectedIdentity();
        this.menu.setSelectionListener(this::onItemSelected);
        this.menu.setOnInventoryChange(this::onInventoryUpdate);
        this.loadSelectedItemProperties();
        this.loadInterfaceState();
        gui.onTick(this::tick);
        gui.onClose(this::saveInterfaceState);
    }

    private void setupCurioSlots() {
        if (!EquipmentManager.equipModLoaded() || this.menu.curios.slots().isEmpty()) {
            return;
        }
        GuiTexture background = new GuiTexture(this.root, BCGuiTextures.themedGetter((String)"background_dynamic")).dynamicTexture();
        GuiScrolling scroll = new GuiScrolling(this.root);
        Constraints.bind((ConstrainedGeometry)scroll, (ConstrainedGeometry)background, (double)4.0);
        GuiSlots slots = (GuiSlots)((GuiSlots)new GuiSlots((GuiParent)scroll.getContentElement(), this.screenAccess, this.menu.curios, 1).setSlotOverlay(this::renderSlotOverlay).setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")).setEmptyIconI(i -> RenderUtils.fromRawTexture((ResourceLocation)EquipmentManager.getIcons((LivingEntity)this.menu.inventory.player).get((int)i))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)scroll.getContentElement().get(GeoParam.LEFT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)scroll.getContentElement().get(GeoParam.TOP)));
        background.constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)slots.get(GeoParam.WIDTH), () -> scroll.hiddenSize(Axis.Y) > 0.0 ? 12.0 : 8.0));
        background.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> Math.min(this.mainUI.ySize(), slots.ySize() + 8.0)));
        background.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.mainUI.get(GeoParam.LEFT), (double)-2.0));
        background.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.mainUI.get(GeoParam.TOP)));
        GuiSlider bar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider((GuiParent)background, Axis.Y).setEnabled(() -> scroll.hiddenSize(Axis.Y) > 0.0)).setSliderState(scroll.scrollState(Axis.Y)).setScrollableElement((GuiElement)slots).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-4.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)slots.get(GeoParam.RIGHT), (double)1.0));
        bar.installSlider((GuiElement)new GuiRectangle((GuiParent)bar).fill(() -> BCConfig.darkMode ? -2130706433 : -1157627904)).bindSliderWidth().bindSliderLength();
    }

    private void setupSimpleUI(GuiElement<?> playerInv) {
        GuiRectangle border = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)TOOLKIT.embossBorder((GuiParent)this.mainUI).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.mainUI.get(GeoParam.TOP), (double)15.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.mainUI.get(GeoParam.LEFT), (double)15.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.mainUI.get(GeoParam.RIGHT), (double)-15.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)playerInv.get(GeoParam.TOP), (double)-4.0));
        border.setEnabled(() -> border.ySize() > 20.0);
        this.simpleUIScroll = new GuiScrolling((GuiParent)border);
        Constraints.bind((ConstrainedGeometry)this.simpleUIScroll, (ConstrainedGeometry)border, (double)2.0);
        this.simpleUIScroll.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)border.get(GeoParam.RIGHT), () -> this.simpleUIScroll.hiddenSize(Axis.Y) > 0.0 ? -7.0 : -2.0));
        this.simpleUIScroll.getContentElement().constrain(GeoParam.WIDTH, null);
        this.simpleUIScroll.getContentElement().constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.simpleUIScroll.get(GeoParam.RIGHT)));
        GuiSlider bar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider((GuiParent)border, Axis.Y).setEnabled(() -> this.simpleUIScroll.hiddenSize(Axis.Y) > 0.0)).setSliderState(this.simpleUIScroll.scrollState(Axis.Y)).setScrollableElement((GuiElement)this.simpleUIScroll).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.simpleUIScroll.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.simpleUIScroll.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)5.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.simpleUIScroll.get(GeoParam.RIGHT), (double)0.0));
        bar.installSlider((GuiElement)new GuiRectangle((GuiParent)bar).fill(() -> BCConfig.darkMode ? -2130706433 : -1157627904)).bindSliderWidth().bindSliderLength();
    }

    private void loadSelectedItemProperties() {
        GuiElement content = this.simpleUIScroll.getContentElement();
        content.getChildren().forEach(arg_0 -> ((GuiElement)content).removeChild(arg_0));
        this.simpleUIScroll.scrollState(Axis.Y).setPos(0.0);
        PropertyProvider provider = this.menu.findProvider(this.selectedItem, (HolderLookup.Provider)this.gui.mc().level.registryAccess());
        if (provider != null) {
            double yOffset = 0.0;
            int index = 0;
            for (ConfigProperty property : provider.getProperties()) {
                PropertyData data = new PropertyData(provider, property, true);
                data.setChangeListener(() -> data.sendToServer(this.gui.mc().player.registryAccess()));
                PropertyElement propEle = (PropertyElement)((PropertyElement)((PropertyElement)new PropertyElement((GuiParent<?>)content, data, this, index, false).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)content.get(GeoParam.TOP), (double)yOffset));
                yOffset += propEle.ySize();
                ++index;
            }
        }
    }

    private void setupAdvancedUI() {
        this.deleteZone = (GuiElement)((GuiButton)TOOLKIT.createIconButton(this.root, 16, BCGuiTextures.getter((String)"delete"), true).setEnabled(() -> this.advancedUI && DEConfig.configUiEnableDeleteZone)).setTooltip(new Component[]{Component.translatable((String)"gui.draconicevolution.item_config.delete_zone.info")});
        Constraints.placeInside(this.deleteZone, this.root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT);
        GuiButton addGroup = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createIconButton(this.root, 16, BCGuiTextures.getter((String)"new_group"), true).setEnabled(() -> this.advancedUI && DEConfig.configUiEnableAddGroupButton)).setTooltip(new Component[]{Component.translatable((String)"gui.draconicevolution.item_config.add_group.info")})).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.root.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.root.get(GeoParam.TOP), () -> this.deleteZone.isEnabled() ? 17.0 : 0.0))).onClick(() -> new PropertyContainer((GuiParent<?>)this.root, this, true));
    }

    private void onItemSelected(boolean initialLoad) {
        if (this.selectedItem != this.menu.getSelectedIdentity() && !this.advancedUI) {
            this.selectedItem = this.menu.getSelectedIdentity();
            this.loadSelectedItemProperties();
        } else if (this.advancedUI && !initialLoad) {
            PropertyProvider provider = this.menu.findProvider(this.menu.getSelectedIdentity(), (HolderLookup.Provider)this.gui.mc().level.registryAccess());
            if (provider == null || provider.getProperties().isEmpty()) {
                return;
            }
            GuiContextMenu ctxMenu = GuiContextMenu.tooltipStyleMenu((GuiParent)this.mainUI).actionOnClick();
            for (ConfigProperty property : provider.getProperties()) {
                ctxMenu.addOption(property::getDisplayName, () -> {
                    PropertyContainer container = new PropertyContainer((GuiParent<?>)this.root, this, false);
                    container.addProperty(new PropertyData(provider, property, true));
                });
            }
            ctxMenu.setNormalizedPos(this.gui.computeMouseX(), this.gui.computeMouseY());
        }
        if (!initialLoad) {
            this.gui.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }

    private void onInventoryUpdate() {
    }

    public void newContainer(PropertyContainer container) {
        if (!this.cancelAutoPos) {
            container.setPos((int)(this.gui.computeMouseX() - (container.xSize() - 5.0)), (int)this.gui.computeMouseY() - 5);
            container.startDragging();
        }
        if (!this.propertyContainers.contains((Object)container)) {
            this.propertyContainers.add(container);
        }
    }

    private void tick() {
        ModuleHost provider;
        Slot hovered;
        if ((double)(this.isNormalUI() ? 1 : 0) != this.resizeAnim || (double)(!this.advancedUI ? 1 : 0) != this.positionAnim || (double)(this.isMinimized() ? 1 : 0) != this.minimizeAnim) {
            this.resizeAnim = MathHelper.clip((double)MathHelper.approachLinear((double)this.resizeAnim, (double)(this.isNormalUI() ? 1 : 0), (double)0.15f), (double)0.0, (double)1.0);
            this.minimizeAnim = MathHelper.clip((double)MathHelper.approachLinear((double)this.minimizeAnim, (double)(this.isMinimized() ? 1 : 0), (double)0.15f), (double)0.0, (double)1.0);
            this.positionAnim = MathHelper.clip((double)MathHelper.approachLinear((double)this.positionAnim, (double)(!this.advancedUI ? 1 : 0), (double)0.15f), (double)0.0, (double)1.0);
        }
        this.hoveredData = null;
        this.hoveredProvider = null;
        if (DEConfig.configUiEnableVisualization && (hovered = (Slot)this.menu.slots.stream().filter(slot -> ((ModularGuiContainer)this.gui.getScreen()).isHovering(slot, this.gui.computeMouseX(), this.gui.computeMouseY())).findAny().orElse(null)) != null && (provider = DECapabilities.getHost(hovered.getItem())) != null) {
            this.hoveredProvider = provider;
        }
        if (!this.bindReleased) {
            InputConstants.Key bind = KeyBindings.toolConfig.getKey();
            if (!InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)bind.getValue())) {
                if (this.closeOnRelease) {
                    this.gui.getScreen().onClose();
                } else {
                    this.bindReleased = true;
                }
            } else if (this.holdTimer > 10) {
                this.closeOnRelease = true;
            }
            ++this.holdTimer;
        }
    }

    private boolean isNormalUI() {
        return !this.advancedUI;
    }

    private boolean isMinimized() {
        return this.advancedUI && this.minimize;
    }

    private Component getGuiTitle(ConfigurableItemMenu menu, GuiElement<?> element) {
        if (this.advancedUI || menu.getLastStack().isEmpty()) {
            return TOOLKIT.translate("name", new Object[0]);
        }
        MutableComponent prefix = TOOLKIT.translate("configure", new Object[0]).append(" ");
        Component name = menu.getLastStack().getHoverName();
        if ((double)(element.font().width((FormattedText)prefix) + element.font().width((FormattedText)name)) > element.xSize()) {
            return name;
        }
        return prefix.append(name);
    }

    private void renderSlotOverlay(Slot slot, Position pos, GuiRender render) {
        ItemStack stack = slot.getItem();
        ModuleHost provider = DECapabilities.getHost(stack);
        if (!stack.isEmpty() && provider != null) {
            ConfigProperty prop;
            int light = -268971;
            int dark = -763643;
            render.shadedRect(pos.x() - 1.0, pos.y() - 1.0, 18.0, 18.0, 1.0, dark, light, 0);
            if (!this.advancedUI && provider.getIdentity().equals(this.menu.getSelectedIdentity())) {
                render.rect(pos.x(), pos.y(), 16.0, 16.0, -2130771968);
            } else if (DEConfig.configUiEnableVisualization && this.hoveredData != null && (prop = this.hoveredData.getPropIfApplicable(provider)) != null) {
                render.rect(pos.x(), pos.y(), 16.0, 16.0, this.hoveredData.doesDataMatch(prop) ? -2147418368 : -2130734848);
            }
            if (DEConfig.configUiEnableVisualization && !this.updateAnimations.isEmpty()) {
                this.updateAnimations.stream().filter(e -> e.data.getPropIfApplicable(provider) != null).forEach(e -> e.render(pos.x(), pos.y(), render));
            }
        } else {
            render.rect(pos.x() - 1.0, pos.y() - 1.0, 18.0, 18.0, BCConfig.darkMode ? -1342177280 : -1593835521);
        }
    }

    private void openOptionsDialog() {
        GuiContextMenu.tooltipStyleMenu(this.root).addOption(() -> Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiShowUnavailable ? "hide_unavailable" : "show_unavailable"))), () -> Collections.singletonList(Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiShowUnavailable ? "hide_unavailable" : "show_unavailable") + ".info"))), () -> DEConfig.modifyClientProperty("showUnavailable", tag -> tag.setBoolean(!DEConfig.configUiShowUnavailable), "itemConfigGUI")).addOption(() -> Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiEnableSnapping ? "disable_snapping" : "enable_snapping"))), () -> Collections.singletonList(Component.translatable((String)"gui.draconicevolution.item_config.disable_snapping.info")), () -> DEConfig.modifyClientProperty("enableSnapping", tag -> tag.setBoolean(!DEConfig.configUiEnableSnapping), "itemConfigGUI")).addOption(() -> Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiEnableVisualization ? "disable_visualization" : "enable_visualization"))), () -> Collections.singletonList(Component.translatable((String)"gui.draconicevolution.item_config.disable_visualization.info")), () -> DEConfig.modifyClientProperty("enableVisualization", tag -> tag.setBoolean(!DEConfig.configUiEnableVisualization), "itemConfigGUI")).addOption(() -> Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiEnableAddGroupButton ? "hide_group_button" : "show_group_button"))), () -> DEConfig.modifyClientProperty("enableAddGroupButton", tag -> tag.setBoolean(!DEConfig.configUiEnableAddGroupButton), "itemConfigGUI")).addOption(() -> Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiEnableDeleteZone ? "hide_delete_zone" : "show_delete_zone"))), () -> DEConfig.modifyClientProperty("enableDeleteZone", tag -> tag.setBoolean(!DEConfig.configUiEnableDeleteZone), "itemConfigGUI")).addOption(() -> Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiEnableAdvancedXOver ? "disable_adv_xover" : "enable_adv_xover"))), () -> Collections.singletonList(Component.translatable((String)("gui.draconicevolution.item_config." + (DEConfig.configUiShowUnavailable ? "disable_adv_xover" : "enable_adv_xover") + ".info"))), () -> DEConfig.modifyClientProperty("enableAdvancedXOver", tag -> tag.setBoolean(!DEConfig.configUiEnableAdvancedXOver), "itemConfigGUI")).setCloseOnItemClicked(false).setNormalizedPos(this.gui.computeMouseX(), this.gui.computeMouseY());
    }

    private void loadInterfaceState() {
        this.cancelAutoPos();
        CompoundTag nbt = ItemConfigDataHandler.retrieveData();
        this.advancedUI = nbt.getBoolean("advanced");
        this.minimize = nbt.getBoolean("minimize");
        this.propertyContainers.forEach(arg_0 -> this.root.removeChild(arg_0));
        this.propertyContainers.clear();
        nbt.getList("property_containers", 10).stream().map(e -> (CompoundTag)e).map(e -> PropertyContainer.deserialize(this, this.root, e, (HolderLookup.Provider)this.gui.mc().player.registryAccess())).toList();
        this.resizeAnim = this.isNormalUI() ? 1.0 : 0.0;
        this.minimizeAnim = this.isMinimized() ? 1.0 : 0.0;
        this.positionAnim = this.advancedUI ? 0.0 : 1.0;
        this.propertyContainers.forEach(PropertyContainer::inventoryUpdate);
        this.resumeAutoPos();
    }

    protected void saveInterfaceState() {
        keyBindCache = null;
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("advanced", this.advancedUI);
        nbt.putBoolean("minimize", this.minimize);
        nbt.put("property_containers", (Tag)this.propertyContainers.stream().map(e -> e.serialize((HolderLookup.Provider)this.gui.mc().player.registryAccess())).collect(Collectors.toCollection(ListTag::new)));
        ItemConfigDataHandler.saveData(nbt);
    }

    private void openModulesGui() {
        this.gui.getScreen().onClose();
        DraconicNetwork.sendOpenModuleConfig(this.gui.mc().player.registryAccess());
    }

    public static void checkKeybinding(int keyCode, int scanCode) {
        List<PropertyContainer> presets;
        net.minecraft.client.gui.screens.Screen screen = Minecraft.getInstance().screen;
        LocalPlayer player = Minecraft.getInstance().player;
        if (screen instanceof Screen || player == null) {
            return;
        }
        InputConstants.Key input = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (keyBindCache == null) {
            ModularGui dummy = new ModularGui(e -> {});
            keyBindCache = new ArrayList<PropertyContainer>();
            CompoundTag nbt = ItemConfigDataHandler.retrieveData();
            List<PropertyContainer> containers = nbt.getList("property_containers", 10).stream().map(e -> (CompoundTag)e).map(arg_0 -> ConfigurableItemGui.lambda$checkKeybinding$63(dummy, (Player)player, arg_0)).toList();
            containers.stream().filter(e -> !e.boundKey.isEmpty() && e.globalKeyBind && e.presetMode).forEach(e -> keyBindCache.add((PropertyContainer)((Object)e)));
            keyBindCache.sort(Comparator.comparing(e -> e.modifier.ordinal()));
        }
        if ((presets = keyBindCache.stream().filter(container -> input.toString().equals(container.boundKey) && container.modifier.isActive(null)).toList()).isEmpty()) {
            return;
        }
        if (presets.size() == 1) {
            MULTI_BIND_INDEX_MAP.remove(input);
            presets.get(0).applyPreset();
        } else {
            int next = (MULTI_BIND_INDEX_MAP.getOrDefault(input, -1) + 1) % presets.size();
            presets.get(next).applyPreset();
            MULTI_BIND_INDEX_MAP.put(input, next);
        }
    }

    public void cancelAutoPos() {
        this.cancelAutoPos = true;
    }

    public void resumeAutoPos() {
        this.cancelAutoPos = false;
    }

    private static /* synthetic */ PropertyContainer lambda$checkKeybinding$63(ModularGui dummy, Player player, CompoundTag e) {
        return PropertyContainer.deserialize(null, dummy.getRoot(), e, (HolderLookup.Provider)player.registryAccess());
    }

    public static class Screen
    extends ModularGuiContainer<ConfigurableItemMenu> {
        public Screen(ConfigurableItemMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new ConfigurableItemGui());
            this.getModularGui().setGuiTitle(title);
        }

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.render(graphics, mouseX, mouseY, partialTicks);
            ((ConfigurableItemGui)this.modularGui.getProvider()).updateAnimations.removeIf(UpdateAnim::isFinished);
            ((ConfigurableItemGui)this.modularGui.getProvider()).updateAnimations.forEach(e -> e.tick(partialTicks));
        }
    }

    protected static class UpdateAnim {
        private float tick = 0.0f;
        private PropertyData data;

        public UpdateAnim(PropertyData data) {
            this.data = data;
        }

        private void tick(float partialTicks) {
            this.tick += partialTicks;
            if (this.tick > 10.0f) {
                this.tick = 20.0f;
            }
        }

        private boolean isFinished() {
            return this.tick >= 10.0f;
        }

        public void render(double x, double y, GuiRender render) {
            if (!this.isFinished()) {
                float offset = this.tick / 10.0f * 8.0f;
                render.fill(x + (double)offset, y + (double)offset, x + 16.0 - (double)offset, y + 16.0 - (double)offset, 0x5000FFFF);
            }
        }
    }
}

