/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AutoFeedEntity
extends ModuleEntity<AutoFeedData> {
    private BooleanProperty consumeFood = new BooleanProperty("feed_mod.consume_food", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private double storedFood = 0.0;
    public static final Codec<AutoFeedEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)Codec.DOUBLE.fieldOf("stored_food").forGetter(e -> e.storedFood), (App)BooleanProperty.CODEC.fieldOf("consume_food").forGetter(e -> e.consumeFood)).apply((Applicative)builder, AutoFeedEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutoFeedEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)ByteBufCodecs.DOUBLE, e -> e.storedFood, BooleanProperty.STREAM_CODEC, e -> e.consumeFood, AutoFeedEntity::new);

    public AutoFeedEntity(Module<AutoFeedData> module) {
        super(module);
    }

    AutoFeedEntity(Module<?> module, int gridX, int gridY, double storedFood, BooleanProperty consumeFood) {
        super(module, gridX, gridY);
        this.consumeFood = consumeFood;
        this.storedFood = storedFood;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new AutoFeedEntity(this.module, this.getGridX(), this.getGridY(), this.getStoredFood(), this.consumeFood.copy());
    }

    public void setStoredFood(double storedFood) {
        if (this.storedFood != storedFood) {
            this.markDirty();
        }
        this.storedFood = storedFood;
    }

    public double getStoredFood() {
        return this.storedFood;
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        properties.add(this.consumeFood);
    }

    @Override
    public void tick(ModuleContext context) {
        LivingEntity entity;
        AutoFeedData data = (AutoFeedData)this.module.getData();
        if (context instanceof StackModuleContext && (entity = ((StackModuleContext)context).getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (entity.tickCount % 10 == 0 && ((StackModuleContext)context).isEquipped()) {
                if (this.getStoredFood() < data.foodStorage() && this.consumeFood.getValue()) {
                    for (ItemStack stack : player.getInventory().items) {
                        FoodProperties food = stack.getFoodProperties((LivingEntity)player);
                        if (stack.isEmpty() || food == null || food.nutrition() <= 0 || !food.effects().isEmpty()) continue;
                        double val = (float)food.nutrition() + food.saturation();
                        double rem = this.getStoredFood() + val - data.foodStorage();
                        if (!(rem <= val * 0.25)) continue;
                        this.setStoredFood((float)Math.min(this.getStoredFood() + val, data.foodStorage()));
                        entity.level().playSound(null, entity.blockPosition(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.25f, 0.95f + entity.level().random.nextFloat() * 0.1f);
                        stack.shrink(1);
                        break;
                    }
                }
                FoodData foodStats = player.getFoodData();
                if (this.getStoredFood() > 0.0 && (foodStats.getFoodLevel() < 20 || foodStats.getSaturationLevel() < 20.0f)) {
                    double maxSat;
                    TechLevel tech = this.module.getModuleTechLevel();
                    double d = maxSat = entity.tickCount % 20 == 0 && tech == TechLevel.DRACONIC ? 20.0 : 1.0;
                    if (foodStats.needsFood() && this.getStoredFood() > 1.0) {
                        foodStats.eat((int)this.consumeFood(Math.min(1, 20 - foodStats.getFoodLevel())), 0.0f);
                    } else if ((double)foodStats.getSaturationLevel() < maxSat && this.getStoredFood() > 0.0) {
                        foodStats.setSaturation(foodStats.getSaturationLevel() + (float)this.consumeFood(Math.min(1.0, maxSat - (double)foodStats.getSaturationLevel())));
                    }
                }
            }
        }
    }

    private double consumeFood(double amount) {
        amount = Math.min(amount, this.getStoredFood());
        this.setStoredFood(this.getStoredFood() - amount);
        return amount;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
        AutoFeedData data = (AutoFeedData)this.module.getData();
        double progress = this.getStoredFood() / data.foodStorage();
        progress = (int)(progress * 21.0);
        progress = 20.0 - progress - 1.0;
        for (int i = 0; i < 10; ++i) {
            float size = (float)(width - 3) / 10.0f;
            render.texRect(BCGuiTextures.get((String)"bars/food_empty"), (double)((float)(x + 1) + (float)i * size), (double)((float)(y + height) - size - 2.0f), (double)(size + 1.0f), (double)(size + 1.0f));
            if (!(progress / 2.0 <= (double)i)) continue;
            if (progress / 2.0 < (double)i) {
                render.texRect(BCGuiTextures.get((String)"bars/food_full"), (double)((float)(x + 1) + (float)i * size), (double)((float)(y + height) - size - 2.0f), (double)(size + 1.0f), (double)(size + 1.0f));
                continue;
            }
            render.texRect(BCGuiTextures.get((String)"bars/food_half"), (double)((float)(x + 1) + (float)i * size), (double)((float)(y + height) - size - 2.0f), (double)(size + 1.0f), (double)(size + 1.0f));
        }
    }

    @Override
    public void addToolTip(List<Component> list) {
        list.add((Component)Component.translatable((String)"module.draconicevolution.auto_feed.stored").withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.translatable((String)"module.draconicevolution.auto_feed.stored.value", (Object[])new Object[]{(int)this.getStoredFood()}).withStyle(ChatFormatting.DARK_GREEN)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"module.draconicevolution.auto_feed.stored").withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.translatable((String)"module.draconicevolution.auto_feed.stored.value", (Object[])new Object[]{(int)this.getStoredFood()}).withStyle(ChatFormatting.DARK_GREEN)));
        }
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        stack.set(ItemData.AUTO_FEED_MODULE_FOOD, (Object)this.getStoredFood());
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.consumeFood.copy());
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.setStoredFood((Double)stack.getOrDefault(ItemData.AUTO_FEED_MODULE_FOOD, (Object)0.0));
        this.consumeFood = ((BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.consumeFood)).copy();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AutoFeedEntity)) {
            return false;
        }
        AutoFeedEntity that = (AutoFeedEntity)o;
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.storedFood, that.storedFood) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storedFood);
    }
}

