/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModItems;

@EventBusSubscriber(modid="farmersdelight")
@ParametersAreNonnullByDefault
public class VillagerEvents {
    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (!((Boolean)Configuration.FARMERS_BUY_FD_CROPS.get()).booleanValue()) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        VillagerProfession profession = event.getType();
        ResourceLocation professionKey = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
        if (professionKey == null) {
            return;
        }
        if (professionKey.getPath().equals("farmer")) {
            ((List)trades.get(1)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)ModItems.ONION.get(), 26, 16, 2));
            ((List)trades.get(1)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)ModItems.TOMATO.get(), 26, 16, 2));
            ((List)trades.get(2)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)ModItems.CABBAGE.get(), 16, 16, 5));
            ((List)trades.get(2)).add(VillagerEvents.emeraldForItemsTrade((ItemLike)ModItems.RICE.get(), 20, 16, 5));
        }
    }

    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent event) {
        if (((Boolean)Configuration.WANDERING_TRADER_SELLS_FD_ITEMS.get()).booleanValue()) {
            List trades = event.getGenericTrades();
            trades.add(VillagerEvents.itemForEmeraldTrade((ItemLike)ModItems.CABBAGE_SEEDS.get(), 1, 12));
            trades.add(VillagerEvents.itemForEmeraldTrade((ItemLike)ModItems.TOMATO_SEEDS.get(), 1, 12));
            trades.add(VillagerEvents.itemForEmeraldTrade((ItemLike)ModItems.RICE.get(), 1, 12));
            trades.add(VillagerEvents.itemForEmeraldTrade((ItemLike)ModItems.ONION.get(), 1, 12));
        }
    }

    public static BasicItemListing emeraldForItemsTrade(ItemLike item, int count, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.EMERALD), maxTrades, xp, 0.05f);
    }

    public static BasicItemListing itemForEmeraldTrade(ItemLike item, int maxTrades, int xp) {
        return new BasicItemListing(1, new ItemStack(item), maxTrades, xp, 0.05f);
    }
}

