/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import vectorwing.farmersdelight.common.Configuration;

public record ChanceResult(ItemStack stack, float chance) {
    public static final ChanceResult EMPTY = new ChanceResult(ItemStack.EMPTY, 1.0f);
    public static final Codec<ChanceResult> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.CODEC.fieldOf("item").forGetter(ChanceResult::stack), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ChanceResult::chance)).apply((Applicative)inst, ChanceResult::new));

    public ItemStack rollOutput(RandomSource rand, int fortuneLevel) {
        int outputAmount = this.stack.getCount();
        double fortuneBonus = (Double)Configuration.CUTTING_BOARD_FORTUNE_BONUS.get() * (double)fortuneLevel;
        for (int roll = 0; roll < this.stack.getCount(); ++roll) {
            if (!((double)rand.nextFloat() > (double)this.chance + fortuneBonus)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack out = this.stack.copy();
        out.setCount(outputAmount);
        return out;
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)this.stack());
        buffer.writeFloat(this.chance());
    }

    public static ChanceResult read(RegistryFriendlyByteBuf buffer) {
        return new ChanceResult((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readFloat());
    }
}

