/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.protocontainer.energy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.protocontainer.TransferAction;
import tv.soaryn.xycraft.core.utils.protocontainer.energy.IEnergyHandler;

public class EnergyStorage
implements IEnergyHandler,
INBTSerializable<Tag> {
    public static Codec<EnergyStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("capacity").forGetter(data -> data.capacity), (App)Codec.INT.fieldOf("maxReceive").forGetter(data -> data.maxInsert), (App)Codec.INT.fieldOf("maxExtract").forGetter(data -> data.maxExtract), (App)Codec.INT.fieldOf("energy").forGetter(data -> data.energy)).apply((Applicative)instance, EnergyStorage::new));
    protected int energy;
    protected int capacity;
    protected int maxInsert;
    protected int maxExtract;

    public EnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public EnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorage(int capacity, int maxInsert, int maxExtract) {
        this(capacity, maxInsert, maxExtract, 0);
    }

    public EnergyStorage(int capacity, int maxInsert, int maxExtract, int energy) {
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0, Math.min(capacity, energy));
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int insert(int index, int amount, TransferAction action) {
        if (!this.allowsInsertion(index) || amount <= 0) {
            return 0;
        }
        int energyReceived = Mth.clamp((int)(this.capacity - this.energy), (int)0, (int)Math.min(this.maxInsert, amount));
        if (action.isExecuting()) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int insert(int amount, TransferAction action) {
        return this.insert(0, amount, action);
    }

    @Override
    public int extract(int index, int amount, TransferAction action) {
        if (!this.allowsExtraction(index) || amount <= 0) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, amount));
        if (action.isExecuting()) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int extract(int amount, TransferAction action) {
        return this.extract(0, amount, action);
    }

    @Override
    public int getAmount(int index) {
        return this.energy;
    }

    @Override
    public int getCapacity(int index) {
        return this.capacity;
    }

    @Override
    public boolean allowsInsertion(int index) {
        return this.maxInsert > 0;
    }

    @Override
    public boolean allowsInsertion() {
        return this.allowsInsertion(0);
    }

    @Override
    public boolean allowsExtraction() {
        return this.allowsExtraction(0);
    }

    @Override
    public boolean allowsExtraction(int index) {
        return this.maxExtract > 0;
    }

    @Deprecated(since="1.22")
    public Tag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return IntTag.valueOf((int)this.getAmount(0));
    }

    @Deprecated(since="1.22")
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.energy = intNbt.getAsInt();
    }
}

