/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;

public final class DirectionUtils {
    public static final Set<Set<Direction>> DirectionMapping = IntStream.range(0, 7).mapToObj(index -> Sets.combinations(EnumSet.allOf(Direction.class), (int)index)).flatMap(Collection::stream).collect(Collectors.toSet());
    public static final Reference2IntMap<Direction> DirectionCodes = (Reference2IntMap)Direction.stream().collect(Reference2IntOpenHashMap::new, (intMap, direction) -> intMap.put(direction, 1 << direction.ordinal()), Map::putAll);

    private DirectionUtils() {
    }

    public static <T> Int2ObjectMap<T> map(BiConsumer<Int2ObjectOpenHashMap<T>, Set<Direction>> consumer) {
        return (Int2ObjectMap)DirectionMapping.stream().collect(Int2ObjectOpenHashMap::new, consumer, Int2ObjectOpenHashMap::putAll);
    }

    public static int hash(Iterable<Direction> direction) {
        int hash = 0;
        for (Direction dir : direction) {
            hash += DirectionUtils.hash(dir);
        }
        return hash;
    }

    public static int hash(Direction direction) {
        return DirectionCodes.getInt((Object)direction);
    }
}

