/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets.drawable;

import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.utils.Utils;

public class DrawableItem
extends DrawableWidget<DrawableItem> {
    private ItemStack _item = ItemStack.EMPTY;
    private List<ItemStack> _items = new ArrayList<ItemStack>();
    private boolean _showCount;
    private float timer = 0.0f;
    private int index = 0;

    private DrawableItem() {
    }

    public static DrawableItem create() {
        DrawableItem drawable = new DrawableItem();
        drawable.onToolTip((widget, mouseX, mouseY, tooltip) -> {
            if (widget.Visible && !widget._item.isEmpty()) {
                tooltip.add(widget._item.getHoverName());
            }
        });
        drawable.showCount(true);
        return drawable;
    }

    public DrawableItem showCount(boolean value) {
        this._showCount = value;
        return this;
    }

    public DrawableItem item(ItemStack item) {
        this._item = item;
        this._items = List.of(item);
        return this;
    }

    public DrawableItem item(ItemStack[] item, int amount) {
        this._item = item[0];
        this._items = Arrays.stream(item).map(stack -> stack.copyWithCount(amount)).toList();
        return this;
    }

    public DrawableItem item(Ingredient ingredient) {
        this._items = Arrays.asList(ingredient.getItems());
        return this;
    }

    @Override
    protected void drawWidget(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        ItemStack item;
        if (this._items.isEmpty()) {
            this._item = ItemStack.EMPTY;
            return;
        }
        this.timer += 1.0f;
        if (this.timer > 60.0f) {
            this.index = (this.index + 1) % this._items.size();
            this.timer = 0.0f;
        }
        this._item = item = this._items.get(this.index);
        this.renderItem(graphics, (LivingEntity)Utils.getClientPlayer(), Utils.getClientLevel(), item, x + this.Dimensions.x, y + this.Dimensions.y);
    }

    private void renderItem(GuiGraphics graphics, @NotNull LivingEntity player, @Nullable Level level, ItemStack stack, float x, float y) {
        if (!stack.isEmpty()) {
            Minecraft minecraft = Minecraft.getInstance();
            BakedModel bakedmodel = minecraft.getItemRenderer().getModel(stack, level, player, 0);
            graphics.pose().pushPose();
            graphics.pose().translate(x + 8.0f, y + 8.0f, 150.0f);
            try {
                boolean flag;
                graphics.pose().scale(1.0f, -1.0f, 1.0f);
                graphics.pose().scale(16.0f, 16.0f, 16.0f);
                boolean bl = flag = !bakedmodel.usesBlockLight();
                if (flag) {
                    Lighting.setupForFlatItems();
                }
                minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
                graphics.flush();
                if (flag) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type / Registry Name", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Damage", () -> String.valueOf(stack.getDamageValue()));
                crashreportcategory.setDetail("Item NBT", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            graphics.pose().popPose();
            if (this._showCount && stack.getCount() > 1) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                graphics.drawString(minecraft.font, "" + stack.getCount(), (int)x + 12, (int)y + 8, -1);
                graphics.pose().popPose();
            }
        }
    }
}

