/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets.drawable;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class DrawableBackground
extends DrawableWidget<DrawableBackground> {
    private final TextureAtlas _textureAtlas = (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
    private final TextureAtlasSprite _cloudFXSprite = this._textureAtlas.getSprite(XyCore.resource("block/cloudfx"));
    private ResourceLocation HexResource;
    private int hexWidth = 256;
    private int hexHeight = 256;

    protected DrawableBackground() {
        this.texture(XyCore.resource("textures/gui/hex6.png"));
    }

    public static DrawableBackground create() {
        return new DrawableBackground();
    }

    public DrawableBackground texture(ResourceLocation loc) {
        this.HexResource = loc;
        if (loc == null) {
            return this;
        }
        Optional hexResource = Minecraft.getInstance().getResourceManager().getResource(this.HexResource);
        if (hexResource.isEmpty()) {
            return this;
        }
        try (NativeImage image = NativeImage.read((InputStream)((Resource)hexResource.get()).open());){
            this.hexWidth = image.getWidth();
            this.hexHeight = image.getHeight();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        Vector4f rgba = ColorUtils.convertToRGBAVec(this.Color);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this._textureAtlas.location());
        graphics.setColor(rgba.x(), rgba.y(), rgba.z(), rgba.w());
        TiledIcon.render(poseStack, x, y, this.Dimensions.width, this.Dimensions.height, 1.0f, this._cloudFXSprite, new TiledIcon.TileConfiguration(true, this.Dimensions.width + x, this.Dimensions.height + y));
        float f = 0.25f;
        graphics.setColor(f, f, f, 0.85f);
        if (this.HexResource != null) {
            RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.HexResource);
            float scale = 0.155f;
            TiledIcon.render(poseStack, x, y, this.Dimensions.width, this.Dimensions.height, scale, 0.0f, 1.0f, 0.0f, 1.0f, this.hexWidth, this.hexHeight, new TiledIcon.TileConfiguration(true, this.Dimensions.width, this.Dimensions.height));
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.popPose();
    }
}

