/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.mixins;

import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class RainLevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"renderSnowAndRain"}, cancellable=true, at={@At(value="HEAD")})
    public void preventWeatherRender(LightTexture texture, float f, double x, double y, double z, CallbackInfo ci) {
        if (this.xycraft$isInField(x, y, z)) {
            ci.cancel();
        }
    }

    @Inject(method={"tickRain"}, cancellable=true, at={@At(value="HEAD")})
    public void preventWeatherClientTick(Camera camera, CallbackInfo ci) {
        Vec3 position = camera.getPosition();
        if (this.xycraft$isInField(position.x(), position.y(), position.z())) {
            ci.cancel();
        }
    }

    @Unique
    private boolean xycraft$isInField(double x, double y, double z) {
        return false;
    }
}

