/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.level.xynergy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.ContributionType;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraph;
import tv.soaryn.xycraft.core.content.attachments.level.xynergy.XynergyGraphState;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;

public class XynergyGraphNode {
    public static final Codec<XynergyGraphNode> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("node_value").forGetter(data -> data.Value), (App)ContributionType.Codec.fieldOf("power_type").forGetter(data -> data.Type)).apply((Applicative)builder, XynergyGraphNode::new));
    public long Value;
    public ContributionType Type;
    private transient BlockCapabilityCache<IXynergyNode, @Nullable Void> CacheCapability;

    public XynergyGraphNode(long value, ContributionType contributionType) {
        this.Value = value;
        this.Type = contributionType;
    }

    public XynergyGraphNode(ServerLevel level, long posId, XynergyGraph graph) {
        IXynergyNode cap = this.getCachedCapability(level, posId, BlockPos.of((long)posId), graph);
        if (cap == null) {
            return;
        }
        this.Value = cap.getValue();
        this.Type = cap.getPowerType();
    }

    public IXynergyNode getCachedCapability(ServerLevel level, long posId, BlockPos precomputedPosition, XynergyGraph graph) {
        if (this.CacheCapability == null) {
            this.CacheCapability = BlockCapabilityCache.create(CoreCapabilities.XynergyNode.BLOCK, (ServerLevel)level, (BlockPos)precomputedPosition, null, () -> graph.Graph.containsVertex((Object)posId), () -> {
                graph.dirtyNodes.add(posId);
                graph.State = XynergyGraphState.Invalid;
            });
        }
        return (IXynergyNode)this.CacheCapability.getCapability();
    }
}

