/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.energy.EnergyContainer;

public class SimpleEnergyContainer
implements EnergyContainer {
    private final int[] _slots;
    private final int _capacity;
    @Nullable
    private final Runnable _updateCallback;

    public SimpleEnergyContainer(int[] slots, int capacity, @Nullable Runnable updateCallback) {
        Objects.requireNonNull(slots);
        Objects.checkIndex(0, slots.length);
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this._slots = slots;
        this._capacity = capacity;
        this._updateCallback = updateCallback;
    }

    public static SimpleEnergyContainer simple() {
        return SimpleEnergyContainer.of(1, 1000);
    }

    public static SimpleEnergyContainer of(int size, int capacity) {
        return SimpleEnergyContainer.of(size, capacity, null);
    }

    public static SimpleEnergyContainer of(int size, int capacity, @Nullable Runnable updateCallback) {
        return new SimpleEnergyContainer(new int[size], capacity, updateCallback);
    }

    public static SimpleEnergyContainer from(int[] values, int capacity) {
        return SimpleEnergyContainer.from(values, capacity, null);
    }

    public static SimpleEnergyContainer from(int[] values, int capacity, Runnable updateCallback) {
        return new SimpleEnergyContainer((int[])values.clone(), capacity, updateCallback);
    }

    @Override
    public int size() {
        return this._slots.length;
    }

    @Override
    public int getCapacity(int slot) {
        Objects.checkIndex(slot, this.size());
        return this._capacity;
    }

    @Override
    public int get(int slot) {
        Objects.checkIndex(slot, this.size());
        return this._slots[slot];
    }

    @Override
    public void set(int slot, int value) {
        Objects.checkIndex(slot, this.size());
        this._slots[slot] = value;
        if (this._updateCallback != null) {
            this._updateCallback.run();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this._slots, 0);
        if (this._updateCallback != null) {
            this._updateCallback.run();
        }
    }

    @Override
    @Contract(pure=true)
    public int @NotNull [] copyContents() {
        return (int[])this._slots.clone();
    }

    @Override
    @NotNull
    public EnergyContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    public int[] slots() {
        return this._slots;
    }

    public int capacity() {
        return this._capacity;
    }

    @Nullable
    public Runnable updateCallback() {
        return this._updateCallback;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SimpleEnergyContainer that = (SimpleEnergyContainer)obj;
        return Objects.equals(this._slots, that._slots) && this._capacity == that._capacity && Objects.equals(this._updateCallback, that._updateCallback);
    }

    public int hashCode() {
        return Objects.hash(this._slots, this._capacity, this._updateCallback);
    }

    public String toString() {
        return "SimpleEnergyContainer[capacity=%d, slots=%s]".formatted(this._slots, this._capacity);
    }

    private class Slice
    implements EnergyContainer {
        private final int start;
        private final int length;

        public Slice(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public int get(int slot) {
            Objects.checkIndex(slot, this.size());
            return SimpleEnergyContainer.this.get(slot + this.start);
        }

        @Override
        public void set(int slot, int value) {
            Objects.checkIndex(slot, this.size());
            SimpleEnergyContainer.this.set(slot + this.start, value);
        }

        @Override
        public int getCapacity(int slot) {
            Objects.checkIndex(slot, this.size());
            return SimpleEnergyContainer.this.getCapacity(slot + this.start);
        }

        @Override
        public void clear() {
            Arrays.fill(SimpleEnergyContainer.this._slots, this.start, this.start + this.length, 0);
            if (SimpleEnergyContainer.this._updateCallback != null) {
                SimpleEnergyContainer.this._updateCallback.run();
            }
        }

        @Override
        @NotNull
        public EnergyContainer slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.length);
            return new Slice(this.start + from, to - from);
        }
    }
}

