/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.compat.framedblocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.DyeableBlock;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.utils.DyeColors;
import xfacthd.framedblocks.api.camo.TriggerRegistrar;
import xfacthd.framedblocks.api.camo.block.SimpleBlockCamoContainer;
import xfacthd.framedblocks.api.camo.block.SimpleBlockCamoContainerFactory;
import xfacthd.framedblocks.api.util.Utils;

public final class RainbowBlockCamoContainerFactory
extends SimpleBlockCamoContainerFactory {
    @Nullable
    protected BlockState getStateFromItemStack(Level level, BlockPos pos, Player player, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            DyeColor dye = DyeColor.getColor((ItemStack)player.getItemInHand(InteractionHand.OFF_HAND));
            if (dye == null) {
                return item2.getBlock().defaultBlockState();
            }
            Block block = item2.getBlock();
            if (block instanceof DyeableBlock) {
                DyeableBlock dyeableBlock = (DyeableBlock)block;
                return dyeableBlock.getMap().get(DyeColors.from(dye)).block().defaultBlockState();
            }
        }
        return null;
    }

    public ItemStack dropCamo(SimpleBlockCamoContainer container) {
        Block block = container.getState().getBlock();
        if (!(block instanceof DyeableBlock)) {
            return new ItemStack((ItemLike)container.getState().getBlock());
        }
        DyeableBlock dyeableBlock = (DyeableBlock)block;
        return new ItemStack((ItemLike)dyeableBlock.getMap().get(DyeColors.White).block());
    }

    protected boolean isValidBlock(BlockState camoState, BlockGetter level, BlockPos pos, @Nullable Player player) {
        return !camoState.is(Utils.BLOCK_BLACKLIST) && camoState.getBlock() instanceof DyeableBlock;
    }

    public SimpleBlockCamoContainer handleInteraction(Level level, BlockPos pos, Player player, SimpleBlockCamoContainer camo, ItemStack stack) {
        Block block;
        DyeColor dye = DyeColor.getColor((ItemStack)stack);
        if (dye != null && (block = camo.getState().getBlock()) instanceof DyeableBlock) {
            DyeableBlock dyeableBlock = (DyeableBlock)block;
            DyeColors target = DyeColors.from(dye);
            if (dyeableBlock.ColorSource != target) {
                return (SimpleBlockCamoContainer)camo.copyWithState(dyeableBlock.getMap().get(target).block().withPropertiesOf(camo.getState()));
            }
        }
        return camo;
    }

    public void registerTriggerItems(TriggerRegistrar registrar) {
        for (Item item : ContentMap.getDyeableItemBlockRoots()) {
            registrar.registerApplicationItem(item);
        }
        registrar.registerRemovalItem((Item)Utils.FRAMED_HAMMER.value());
    }
}

