/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.client.render.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tv.soaryn.xycraft.api.client.render.texture.ConnectedTextureHandler;
import tv.soaryn.xycraft.api.client.render.texture.IConnectedTextureHandler;

public class ConnectedTextureModel
implements IUnbakedGeometry<ConnectedTextureModel> {
    private static final Direction[][] AXIS_PLANE_DIRECTIONS = new Direction[][]{{Direction.UP, Direction.NORTH, Direction.DOWN, Direction.SOUTH}, {Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}, {Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST}};
    private final IConnectedTextureHandler connectionHandler;
    private final EnumSet<Direction> enabledFaces;
    private final BlockElement[][] baseElements;
    private final BlockElement[][][] faceElements;
    private static final Vec3i center = new Vec3i(8, 8, 8);

    public ConnectedTextureModel(IConnectedTextureHandler connectionHandler, EnumSet<Direction> enabledFaces, int baseTintIndex, int baseEmissivity, int tintIndex, int emissivity) {
        this.connectionHandler = connectionHandler;
        this.enabledFaces = enabledFaces;
        this.baseElements = new BlockElement[6][4];
        this.faceElements = new BlockElement[6][4][5];
        ExtraFaceData emissiveFace = new ExtraFaceData(-1, emissivity, emissivity, true);
        ExtraFaceData baseFace = new ExtraFaceData(-1, baseEmissivity, baseEmissivity, false);
        for (Direction face : Direction.values()) {
            Direction[] planeDirections = AXIS_PLANE_DIRECTIONS[face.getAxis().ordinal()];
            for (int i = 0; i < 4; ++i) {
                Vec3i corner = face.getNormal().offset(planeDirections[i].getNormal()).offset(planeDirections[(i + 1) % 4].getNormal()).offset(1, 1, 1).multiply(8);
                BlockElement element = new BlockElement(new Vector3f((float)Math.min(center.getX(), corner.getX()), (float)Math.min(center.getY(), corner.getY()), (float)Math.min(center.getZ(), corner.getZ())), new Vector3f((float)Math.max(center.getX(), corner.getX()), (float)Math.max(center.getY(), corner.getY()), (float)Math.max(center.getZ(), corner.getZ())), Map.of(), null, true);
                this.baseElements[face.get3DDataValue()][i] = new BlockElement(element.from, element.to, Map.of(face, new BlockElementFace(face, baseTintIndex, "", new BlockFaceUV(Adjacency.NONE.remap(element.uvsByFace(face)), 0), baseFace, new MutableObject())), null, baseEmissivity <= 0);
                for (Adjacency adjacency : Adjacency.values()) {
                    this.faceElements[face.get3DDataValue()][i][adjacency.ordinal()] = new BlockElement(element.from, element.to, Map.of(face, new BlockElementFace(face, tintIndex, "", new BlockFaceUV(adjacency.remap(element.uvsByFace(face)), 0), emissiveFace, new MutableObject())), null, true);
                }
            }
        }
    }

    @NotNull
    public BakedModel bake(IGeometryBakingContext context, @NotNull ModelBaker bakery, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState modelState, @NotNull ItemOverrides overrides) {
        List[] baseQuads;
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.getRotation().compose(rootTransform), modelState.isUvLocked());
        }
        if (!context.hasMaterial("base")) {
            baseQuads = null;
        } else {
            TextureAtlasSprite baseSprite = spriteGetter.apply(context.getMaterial("base"));
            baseQuads = new List[6];
            for (int i = 0; i < 6; ++i) {
                baseQuads[i] = new ArrayList();
                for (BlockElement element : this.baseElements[i]) {
                    baseQuads[i].add(UnbakedGeometryHelper.bakeElementFace((BlockElement)element, (BlockElementFace)((BlockElementFace)element.faces.values().iterator().next()), (TextureAtlasSprite)baseSprite, (Direction)Direction.values()[i], (ModelState)modelState));
                }
            }
        }
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{spriteGetter.apply(context.getMaterial("texture_single")), spriteGetter.apply(context.getMaterial("texture_connected")), spriteGetter.apply(context.getMaterial("particle"))};
        if (!context.hasMaterial("particle")) {
            sprites[2] = sprites[0];
        }
        BakedQuad[][][] quads = new BakedQuad[6][4][5];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 5; ++k) {
                    BlockElement element;
                    element = this.faceElements[i][j][k];
                    quads[i][j][k] = UnbakedGeometryHelper.bakeElementFace((BlockElement)element, (BlockElementFace)((BlockElementFace)element.faces.values().iterator().next()), (TextureAtlasSprite)Adjacency.values()[k].choose(sprites), (Direction)Direction.values()[i], (ModelState)modelState);
                }
            }
        }
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return new Baked(this.connectionHandler, this.enabledFaces, baseQuads, quads, sprites[2], overrides, context.getTransforms(), renderTypes);
    }

    public void resolveParents(@NotNull Function<ResourceLocation, UnbakedModel> modelGetter, @NotNull IGeometryBakingContext context) {
    }

    public static void sendIMC() {
        InterModComms.sendTo((String)"xycraft_core", (String)"framedblocks", (String)"add_ct_property", ConnectedTextureModel::getData);
    }

    private static ModelProperty<?> getData() {
        return Data.PROPERTY;
    }

    private static enum Adjacency {
        NONE(0, 0, 0, 16, 16),
        HORIZONTAL(1, 8, 0, 16, 8),
        VERTICAL(1, 0, 8, 8, 16),
        BOTH_WITH_CORNER(1, 0, 0, 8, 8),
        BOTH_NO_CORNER(1, 8, 8, 16, 16);

        private final int texture;
        private final int u0;
        private final int v0;
        private final int u1;
        private final int v1;

        private Adjacency(int texture, int u0, int v0, int u1, int v1) {
            this.texture = texture;
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
        }

        public TextureAtlasSprite choose(TextureAtlasSprite[] sprites) {
            return sprites[this.texture];
        }

        public float getU(float delta) {
            return (float)this.u0 + (float)(this.u1 - this.u0) * (delta / 16.0f);
        }

        public float getV(float delta) {
            return (float)this.v0 + (float)(this.v1 - this.v0) * (delta / 16.0f);
        }

        public float[] remap(float[] uvs) {
            return new float[]{this.getU(uvs[0]), this.getV(uvs[1]), this.getU(uvs[2]), this.getV(uvs[3])};
        }

        private static Adjacency of(boolean horizontal, boolean vertical, boolean corner) {
            if (corner) {
                return BOTH_WITH_CORNER;
            }
            if (horizontal) {
                return vertical ? BOTH_NO_CORNER : HORIZONTAL;
            }
            return vertical ? VERTICAL : NONE;
        }
    }

    private static final class Baked
    implements IDynamicBakedModel {
        private final IConnectedTextureHandler connectionHandler;
        private final EnumSet<Direction> enabledFaces;
        @Nullable
        private final List<BakedQuad>[] baseQuads;
        private final BakedQuad[][][] quads;
        private final TextureAtlasSprite particleTexture;
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        private final ChunkRenderTypeSet blockRenderTypes;
        private final List<RenderType> itemRenderTypes;
        private final List<RenderType> fabulousItemRenderTypes;

        private Baked(IConnectedTextureHandler connectionHandler, EnumSet<Direction> enabledFaces, @Nullable List<BakedQuad>[] baseQuads, BakedQuad[][][] quads, TextureAtlasSprite particleTexture, ItemOverrides overrides, ItemTransforms transforms, RenderTypeGroup renderTypes) {
            this.connectionHandler = connectionHandler;
            this.enabledFaces = enabledFaces;
            this.baseQuads = baseQuads;
            this.quads = quads;
            this.particleTexture = particleTexture;
            this.overrides = overrides;
            this.transforms = transforms;
            this.blockRenderTypes = !renderTypes.isEmpty() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderTypes.block()}) : null;
            this.itemRenderTypes = !renderTypes.isEmpty() ? List.of(renderTypes.entity()) : null;
            this.fabulousItemRenderTypes = !renderTypes.isEmpty() ? List.of(renderTypes.entityFabulous()) : null;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
            if (side == null || !this.enabledFaces.contains(side)) {
                return List.of();
            }
            int faceIdx = side.get3DDataValue();
            Data data = (Data)extraData.get(Data.PROPERTY);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(4 + (this.baseQuads != null ? 4 : 0));
            if (this.baseQuads != null) {
                quads.addAll(this.baseQuads[faceIdx]);
            }
            for (int i = 0; i < 4; ++i) {
                Adjacency adjacency = data != null ? data.adjacency[faceIdx][i] : Adjacency.NONE;
                quads.add(this.quads[faceIdx][i][adjacency.ordinal()]);
            }
            return quads;
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            Data data = new Data();
            for (Direction face : this.enabledFaces) {
                Direction[] directions = AXIS_PLANE_DIRECTIONS[face.getAxis().ordinal()];
                boolean[] sideStates = new boolean[4];
                for (int i = 0; i < directions.length; ++i) {
                    sideStates[i] = this.connectionHandler.shouldConnectTexture(level, pos, state, face, directions[i]);
                }
                int faceIndex = face.get3DDataValue();
                for (int i = 0; i < directions.length; ++i) {
                    int j = (i + 1) % directions.length;
                    boolean side1 = sideStates[i];
                    boolean side2 = sideStates[j];
                    boolean corner = side1 && side2 && this.connectionHandler.shouldConnectTexture(level, pos, state, face, directions[i], directions[j]);
                    data.adjacency[faceIndex][i] = i % 2 == 0 ? Adjacency.of(side1, side2, corner) : Adjacency.of(side2, side1, corner);
                }
            }
            return modelData.derive().with(Data.PROPERTY, (Object)data).build();
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return false;
        }

        @NotNull
        public TextureAtlasSprite getParticleIcon() {
            return this.particleTexture;
        }

        @NotNull
        public ItemOverrides getOverrides() {
            return this.overrides;
        }

        @NotNull
        public ItemTransforms getTransforms() {
            return this.transforms;
        }

        @NotNull
        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            if (this.blockRenderTypes != null) {
                return this.blockRenderTypes;
            }
            return super.getRenderTypes(state, rand, data);
        }

        @NotNull
        public List<RenderType> getRenderTypes(@NotNull ItemStack itemStack, boolean fabulous) {
            if (!fabulous) {
                if (this.itemRenderTypes != null) {
                    return this.itemRenderTypes;
                }
            } else if (this.fabulousItemRenderTypes != null) {
                return this.fabulousItemRenderTypes;
            }
            return super.getRenderTypes(itemStack, fabulous);
        }
    }

    private static final class Data {
        private static final ModelProperty<Data> PROPERTY = new ModelProperty();
        private final Adjacency[][] adjacency = new Adjacency[6][4];

        private Data() {
        }

        public int hashCode() {
            return Arrays.deepHashCode((Object[])this.adjacency);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != Data.class) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.adjacency, (Object[])((Data)o).adjacency);
        }
    }

    public static class Loader
    implements IGeometryLoader<ConnectedTextureModel> {
        @NotNull
        public ConnectedTextureModel read(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext deserializationContext) throws JsonParseException {
            IConnectedTextureHandler connectionHandler = this.parseConnectionHandler(jsonObject);
            EnumSet<Direction> faces = this.parseEnabledFaces(jsonObject);
            int baseTintIndex = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"base_tint_index", (int)-1);
            int baseEmissivity = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"base_emissivity", (int)0);
            int tintIndex = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"tint_index", (int)-1);
            int emissivity = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"emissivity", (int)0);
            return new ConnectedTextureModel(connectionHandler, faces, baseTintIndex, baseEmissivity, tintIndex, emissivity);
        }

        private IConnectedTextureHandler parseConnectionHandler(JsonObject jsonObject) {
            String handlerName;
            return switch (handlerName = GsonHelper.getAsString((JsonObject)jsonObject, (String)"connection_handler", (String)"delegate")) {
                case "same_block" -> ConnectedTextureHandler.isSameBlock();
                case "delegate" -> ConnectedTextureHandler.fromBlock();
                default -> {
                    if (handlerName.startsWith("#")) {
                        yield ConnectedTextureHandler.hasTag((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)handlerName.substring(1))));
                    }
                    throw new JsonParseException("Invalid connection handler: " + handlerName);
                }
            };
        }

        private EnumSet<Direction> parseEnabledFaces(JsonObject jsonObject) {
            if (!jsonObject.has("faces")) {
                return EnumSet.allOf(Direction.class);
            }
            EnumSet<Direction> faces = EnumSet.noneOf(Direction.class);
            for (JsonElement element : jsonObject.getAsJsonArray("faces")) {
                Direction face = Direction.byName((String)element.getAsString());
                if (face == null) {
                    throw new JsonParseException("Invalid face: " + element.getAsString());
                }
                faces.add(face);
            }
            return faces;
        }
    }
}

