/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.item.MobPredictionItem;
import dev.shadowsoffire.hostilenetworks.tile.LootFabTileEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.FilteredSlot;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class LootFabContainer
extends BlockEntityMenu<LootFabTileEntity> {
    public LootFabContainer(int id, Inventory pInv, BlockPos pos) {
        super(Hostile.Containers.LOOT_FABRICATOR, id, pInv, pos);
        LootFabTileEntity.FabItemHandler inv = ((LootFabTileEntity)this.tile).getInventory();
        this.addSlot((Slot)new FilteredSlot((InternalItemHandler)inv, 0, 79, 62, s -> s.is(Hostile.Items.PREDICTION)));
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.addSlot((Slot)new FilteredSlot((InternalItemHandler)inv, 1 + y * 4 + x, 100 + x * 18, 7 + y * 18, s -> false));
            }
        }
        this.addPlayerSlots(pInv, 8, 96);
        this.mover.registerRule((stack, slot) -> slot == 0, 17, this.slots.size());
        this.mover.registerRule((stack, slot) -> stack.getItem() instanceof MobPredictionItem, 0, 1);
        this.mover.registerRule((stack, slot) -> slot < 17, 17, this.slots.size());
        this.registerInvShuffleRules();
    }

    public boolean stillValid(Player pPlayer) {
        return pPlayer.level().getBlockState(this.pos).is(Hostile.Blocks.LOOT_FABRICATOR);
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        DynamicHolder<DataModel> model = DataModelItem.getStoredModel(this.getSlot(0).getItem());
        if (!model.isBound() || pId >= ((DataModel)model.get()).fabDrops().size()) {
            return false;
        }
        ((LootFabTileEntity)this.tile).setSelection(model, pId);
        return true;
    }

    public int getEnergyStored() {
        return ((LootFabTileEntity)this.tile).getEnergyStored();
    }

    public int getRuntime() {
        return ((LootFabTileEntity)this.tile).getRuntime();
    }

    public int getSelectedDrop(DataModel model) {
        return ((LootFabTileEntity)this.tile).getSelectedDrop(model);
    }
}

