/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.apache.commons.lang3.tuple.Pair;

public class GenerateModelCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_ENTITY_TYPE = (ctx, builder) -> SharedSuggestionProvider.suggest(BuiltInRegistries.ENTITY_TYPE.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_DATA_MODEL = (ctx, builder) -> SharedSuggestionProvider.suggest(DataModelRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"dropFromLootTable", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = GenerateModelCommand.lootMethodHandle();
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"generate_model_json").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"entity_type", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_ENTITY_TYPE).then(Commands.argument((String)"max_stack_size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            ResourceLocation name = (ResourceLocation)c.getArgument("entity_type", ResourceLocation.class);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(name);
            List<ItemStack> results = GenerateModelCommand.runSimulation(type, (Player)p, 7500, ((Integer)c.getArgument("max_stack_size", Integer.class)).intValue());
            DataModel model = new DataModel(type, Collections.emptyList(), (Component)Component.translatable((String)type.getDescriptionId()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)p.getRandom().nextInt(0xFFFFFF)))), DataModel.DisplayData.DEFAULT, 256, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Hostile.Items.PREDICTION_MATRIX.value()}), new ItemStack((ItemLike)Items.STICK), "hostilenetworks.trivia." + name.getPath(), results, DataModel.RequiredData.EMPTY, DataModel.DataPerKill.EMPTY, Optional.empty());
            GenerateModelCommand.write(name.getNamespace(), name.getPath(), model);
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Data Model JSON generated at datagen/data_models/" + name.getNamespace() + "/" + name.getPath() + ".json")), true);
            return 0;
        }))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"update_model_json").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"data_model", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_DATA_MODEL).then(Commands.argument((String)"max_stack_size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            ResourceLocation name = (ResourceLocation)c.getArgument("data_model", ResourceLocation.class);
            DataModel model = (DataModel)DataModelRegistry.INSTANCE.getValue(name);
            EntityType<?> type = model.entity();
            List<ItemStack> results = GenerateModelCommand.runSimulation(type, (Player)p, 7500, ((Integer)c.getArgument("max_stack_size", Integer.class)).intValue());
            DataModel newModel = new DataModel(model, results);
            GenerateModelCommand.write(name.getNamespace(), name.getPath(), newModel);
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Data Model JSON generated at datagen/data_models/" + name.getNamespace() + "/" + name.getPath() + ".json")), true);
            return 0;
        }))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"generate_all").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"max_stack_size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
                if (!(type.create(p.level()) instanceof Mob)) continue;
                ResourceLocation name = EntityType.getKey((EntityType)type);
                List<ItemStack> results = GenerateModelCommand.runSimulation(type, (Player)p, 7500, ((Integer)c.getArgument("max_stack_size", Integer.class)).intValue());
                if (results.isEmpty()) continue;
                DataModel model = new DataModel(type, Collections.emptyList(), (Component)Component.translatable((String)type.getDescriptionId()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)p.getRandom().nextInt(0xFFFFFF)))), DataModel.DisplayData.DEFAULT, 256, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Hostile.Items.PREDICTION_MATRIX.value()}), new ItemStack((ItemLike)Items.STICK), "hostilenetworks.trivia." + name.getPath(), results, DataModel.RequiredData.EMPTY, DataModel.DataPerKill.EMPTY, Optional.empty());
                GenerateModelCommand.write(name.getNamespace(), name.getPath(), model);
            }
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Data Model JSON files generated at datagen/data_models/"), true);
            return 0;
        })));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"datafix_all").requires(c -> c.hasPermission(2))).executes(c -> {
            ResourceManager resman = ((CommandSourceStack)c.getSource()).getServer().getResourceManager();
            ProfilerFiller profiler = ((CommandSourceStack)c.getSource()).getServer().getProfiler();
            Object map = DataModelRegistry.INSTANCE.prepare(resman, profiler);
            for (Map.Entry entry : map.entrySet()) {
                try {
                    JsonObject out = new JsonObject();
                    JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    if (obj.has("conditions")) {
                        JsonArray conditions = obj.remove("conditions").getAsJsonArray();
                        JsonArray condOut = new JsonArray();
                        conditions.asList().stream().map(JsonElement::getAsJsonObject).map(condObj -> {
                            JsonObject singleCondition = new JsonObject();
                            singleCondition.addProperty("type", condObj.remove("type").getAsString().replace("forge", "neoforge"));
                            for (String s : condObj.keySet()) {
                                singleCondition.add(s, condObj.get(s));
                            }
                            return singleCondition;
                        }).forEach(arg_0 -> ((JsonArray)condOut).add(arg_0));
                        out.add("neoforge:conditions", (JsonElement)condOut);
                    }
                    out.add("entity", obj.remove("entity"));
                    if (obj.has("variants")) {
                        out.add("variants", obj.remove("variants"));
                    } else {
                        out.add("variants", (JsonElement)new JsonArray());
                    }
                    String nameKey = obj.remove("name").getAsString();
                    MutableComponent name = Component.translatable((String)nameKey);
                    if (obj.has("name_color")) {
                        String str;
                        JsonPrimitive colorJson = obj.remove("name_color").getAsJsonPrimitive();
                        TextColor color = colorJson.isNumber() ? TextColor.fromRgb((int)colorJson.getAsInt()) : ((str = colorJson.getAsString()).startsWith("0x") ? TextColor.fromRgb((int)Integer.decode(str)) : (TextColor)TextColor.parseColor((String)str).getOrThrow());
                        name = name.withStyle(s -> s.withColor(color));
                    }
                    out.add("name", (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)name).getOrThrow());
                    float scale = GenerateModelCommand.removeOrDefault(obj, "gui_scale", 1.0f);
                    float xOff = GenerateModelCommand.removeOrDefault(obj, "gui_x_offset", 0.0f);
                    float yOff = GenerateModelCommand.removeOrDefault(obj, "gui_y_offset", 0.0f);
                    float zOff = GenerateModelCommand.removeOrDefault(obj, "gui_z_offset", 0.0f);
                    JsonObject nbt = obj.has("display_nbt") ? obj.remove("display_nbt").getAsJsonObject() : new JsonObject();
                    DataModel.DisplayData display = new DataModel.DisplayData((CompoundTag)((com.mojang.datafixers.util.Pair)CompoundTag.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)nbt).getOrThrow()).getFirst(), scale, xOff, yOff, zOff);
                    out.add("display", (JsonElement)DataModel.DisplayData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)display).getOrThrow());
                    out.add("sim_cost", obj.remove("sim_cost"));
                    JsonObject input = obj.remove("input").getAsJsonObject();
                    JsonObject newInput = new JsonObject();
                    newInput.add("item", input.get("item"));
                    out.add("input", (JsonElement)newInput);
                    JsonObject base = obj.remove("base_drop").getAsJsonObject();
                    JsonObject newBase = new JsonObject();
                    newBase.add("id", base.remove("item"));
                    for (String s2 : base.keySet()) {
                        newBase.add(s2, base.get(s2));
                    }
                    out.add("base_drop", (JsonElement)newBase);
                    out.add("trivia", obj.remove("trivia"));
                    JsonArray fabDrops = obj.remove("fabricator_drops").getAsJsonArray();
                    JsonArray newFabDrops = new JsonArray();
                    fabDrops.asList().stream().map(JsonElement::getAsJsonObject).map(drop -> {
                        JsonObject newDrop = new JsonObject();
                        newDrop.add("id", drop.remove("item"));
                        for (String s : drop.keySet()) {
                            newDrop.add(s, drop.get(s));
                        }
                        return newDrop;
                    }).forEach(arg_0 -> ((JsonArray)newFabDrops).add(arg_0));
                    out.add("fabricator_drops", (JsonElement)newFabDrops);
                    for (String s3 : obj.keySet()) {
                        out.add(s3, obj.get(s3));
                    }
                    GenerateModelCommand.write(((ResourceLocation)entry.getKey()).getNamespace(), ((ResourceLocation)entry.getKey()).getPath(), (JsonElement)out);
                }
                catch (Exception ex) {
                    HostileNetworks.LOGGER.error("Failed to datafix {}", entry.getKey());
                    ex.printStackTrace();
                }
            }
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Data Model JSON files generated at datagen/data_models/"), true);
            return 0;
        }));
    }

    private static float removeOrDefault(JsonObject obj, String key, float value) {
        if (obj.has(key)) {
            return obj.remove(key).getAsFloat();
        }
        return value;
    }

    private static List<ItemStack> runSimulation(EntityType<?> type, Player p, int runs, float maxStackSize) {
        ArrayList allDrops = new ArrayList();
        try {
            Entity entity = type.create(p.level());
            DamageSource src = new DamageSource((Holder)p.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.GENERIC_KILL), (Entity)p);
            for (int i = 0; i < 2500; ++i) {
                entity.moveTo(p.getX(), p.getY(), p.getZ(), 0.0f, 0.0f);
                entity.hurt(src, 1.0f);
                entity.captureDrops(allDrops);
                DROP_LOOT.invoke(entity, src, true);
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        List<ItemStack> items = allDrops.stream().map(ItemEntity::getItem).toList();
        ArrayList<CountedStack> count = new ArrayList<CountedStack>();
        for (ItemStack s : items) {
            boolean found = false;
            for (CountedStack cs2 : count) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)cs2.stack, (ItemStack)s)) continue;
                cs2.count.incrementAndGet();
                found = true;
                break;
            }
            if (found) continue;
            count.add(new CountedStack(s, new AtomicInteger(1)));
        }
        List<Pair> avgs = count.stream().map(cs -> Pair.of((Object)cs.stack, (Object)Float.valueOf((float)cs.count.get() / 2500.0f))).toList();
        float factor = avgs.stream().map(Pair::getRight).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue() / maxStackSize;
        return avgs.stream().map(pair -> {
            ItemStack s = (ItemStack)pair.getLeft();
            s.setCount(Mth.ceil((float)(((Float)pair.getRight()).floatValue() / factor)));
            return s;
        }).sorted((s1, s2) -> Integer.compare(s1.getCount(), s2.getCount()) == 0 ? -BuiltInRegistries.ITEM.getKey((Object)s1.getItem()).compareTo(BuiltInRegistries.ITEM.getKey((Object)s2.getItem())) : -Integer.compare(s1.getCount(), s2.getCount())).toList();
    }

    private static void write(String namespace, String path, DataModel model) {
        JsonElement json = (JsonElement)DataModel.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)model).getOrThrow(JsonSyntaxException::new);
        if (!"minecraft".equals(namespace)) {
            ModLoadedCondition condition = new ModLoadedCondition(namespace);
            JsonArray arr = new JsonArray();
            arr.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow());
            JsonObject copy = new JsonObject();
            copy.add("conditions", (JsonElement)arr);
            json.getAsJsonObject().entrySet().forEach(entry -> copy.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            json = copy;
        }
        GenerateModelCommand.write(namespace, path, json);
    }

    private static void write(String namespace, String path, JsonElement json) {
        File file = new File(FMLPaths.GAMEDIR.get().toFile(), "datagen/data/" + namespace + "/data_models/" + path + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            JsonWriter jWriter = new JsonWriter((Writer)writer);
            jWriter.setIndent("    ");
            GSON.toJson(json, jWriter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private record CountedStack(ItemStack stack, AtomicInteger count) {
    }
}

