/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.container.base.SoulContainerMenu;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public interface SoulContainerProvider {
    default public void openMenu(Player player, InteractionHand hand, SoulMenuConstructor menuConstructor, Consumer<FriendlyByteBuf> extraDataWriter) {
        ItemStack stack = player.getItemInHand(hand);
        Component title = this.getContainerName(stack);
        int slotId = SoulContainerMenu.getSlotIdForHand(player, hand);
        player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _unused) -> menuConstructor.createMenu(containerId, playerInventory, slotId), title), byteBuf -> {
            SoulContainerMenu.writeSlotId(byteBuf, slotId);
            extraDataWriter.accept((FriendlyByteBuf)byteBuf);
        });
    }

    default public void openMenu(Player player, InteractionHand hand, SoulMenuConstructor menuConstructor) {
        this.openMenu(player, hand, menuConstructor, buf -> {});
    }

    public Component getContainerName(ItemStack var1);

    public static interface SoulMenuConstructor {
        @Nullable
        public AbstractContainerMenu createMenu(int var1, Inventory var2, int var3);
    }
}

