/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids.dye;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringFanProcessingType;
import plus.dragons.createdragonsplus.common.registry.CDPFanProcessingTypes;
import plus.dragons.createdragonsplus.mixin.create.FanProcessingAccessor;

public class DyeLiquidBlock
extends LiquidBlock {
    private final DyeColor color;

    public DyeLiquidBlock(DyeColor color, FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
        this.color = color;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ColoringFanProcessingType type = CDPFanProcessingTypes.COLORING.get(this.color).get();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            FanProcessingAccessor.invokeApplyProcessing(itemEntity, type);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            type.applyColoring(livingEntity, level);
        }
    }
}

