/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.core;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import dev.satherov.crystalix.Crystalix;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.client.lang.CSTranslatable;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.common.properties.EnumCodecs;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CSRegistry.class);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"crystalix");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"crystalix");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"crystalix");
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"crystalix");
    public static final DeferredHolder<Item, CrystalixWand> WAND = ITEMS.register("crystalix_wand", () -> new CrystalixWand(new Item.Properties()));
    public static final Table<Types, Colors, DeferredHolder<Block, CrystalixGlass>> ENTRIES = CSRegistry.create();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = TABS.register("creative_tab", () -> CreativeModeTab.builder().title((Component)CSLanguage.CREATIVE_TAB_DEFAULT.text()).icon(() -> ((CrystalixGlass)((Object)((Object)((Object)Objects.requireNonNull((DeferredHolder)ENTRIES.get((Object)Types.GLASS, (Object)Colors.WHITE)).get())))).asItem().getDefaultInstance()).displayItems((param, out) -> ITEMS.getEntries().stream().map(DeferredHolder::get).map(Item::getDefaultInstance).forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0))).build());
    public static final Supplier<DataComponentType<Boolean>> WATERLOGGABLE = COMPONENTS.register("waterlogged", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> INVISIBLE = COMPONENTS.register("invisible", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> SHADELESS = COMPONENTS.register("shadeless", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> REINFORCED = COMPONENTS.register("reinforced", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<CSProperties.Ghost>> GHOST = COMPONENTS.register("ghost", () -> DataComponentType.builder().persistent(CSProperties.Ghost.CODEC).networkSynchronized(CSProperties.Ghost.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<CSProperties.Light>> LIGHT = COMPONENTS.register("light", () -> DataComponentType.builder().persistent(CSProperties.Light.CODEC).networkSynchronized(CSProperties.Light.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Colors>> COLOR = COMPONENTS.register("color", () -> DataComponentType.builder().persistent(Colors.CODEC).networkSynchronized(Colors.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<Boolean>> APPLY_COLORLESS = COMPONENTS.register("apply_colorless", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final TagKey<Item> ITEM_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Crystalix.rl("blocks"));
    public static final Map<Types, TagKey<Item>> ITEM_TAGS = Arrays.stream(Types.values()).collect(Collectors.toMap(Function.identity(), type -> ItemTags.create((ResourceLocation)Crystalix.rl(type.getSerializedName())), (a, b) -> b, () -> new EnumMap(Types.class)));
    public static final TagKey<Block> BLOCK_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Crystalix.rl("blocks"));
    public static final Map<Types, TagKey<Block>> BLOCK_TAGS = Arrays.stream(Types.values()).collect(Collectors.toMap(Function.identity(), type -> BlockTags.create((ResourceLocation)Crystalix.rl(type.getSerializedName())), (a, b) -> b, () -> new EnumMap(Types.class)));

    private static Table<Types, Colors, DeferredHolder<Block, CrystalixGlass>> create() {
        HashBasedTable table = HashBasedTable.create();
        for (Colors color : Colors.values()) {
            for (Types type : Types.values()) {
                String name = color.format(type);
                DeferredHolder holder = BLOCKS.register(name, () -> new CrystalixGlass(type, color));
                ITEMS.register(name, () -> new BlockItem((Block)holder.get(), new Item.Properties()));
                table.put((Object)type, (Object)color, (Object)holder);
            }
        }
        return table;
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TABS.register(bus);
        COMPONENTS.register(bus);
    }

    public static enum Colors implements StringRepresentable,
    CSTranslatable
    {
        CLEAR(-1, MapColor.NONE),
        WHITE(0xF9FFFE, MapColor.SNOW),
        CREAM(0xFFFDD0, MapColor.TERRACOTTA_WHITE),
        FLUORESCENT(15651750, MapColor.SAND),
        YELLOW(16701501, MapColor.COLOR_YELLOW),
        GOLD(16766720, MapColor.GOLD),
        HONEY(16758086, MapColor.TERRACOTTA_YELLOW),
        PEACH(12552547, MapColor.SAND),
        AMBER(13860153, MapColor.TERRACOTTA_ORANGE),
        ORANGE(16351261, MapColor.COLOR_ORANGE),
        PERSIMMON(13778729, MapColor.TERRACOTTA_ORANGE),
        CORAL(0xFF6B6B, MapColor.TERRACOTTA_RED),
        SALMON(16416882, MapColor.TERRACOTTA_PINK),
        ROSE(16714453, MapColor.TERRACOTTA_RED),
        RED(11546150, MapColor.COLOR_RED),
        CRIMSON(14423100, MapColor.CRIMSON_STEM),
        SCARLET(16720896, MapColor.COLOR_RED),
        MAROON(0x910000, MapColor.COLOR_RED),
        BUBBLEGUM(16234198, MapColor.COLOR_PINK),
        PINK(15961002, MapColor.COLOR_PINK),
        MAGENTA(13061821, MapColor.COLOR_MAGENTA),
        FUCHSIA(0xFF00FF, MapColor.COLOR_MAGENTA),
        LAVENDER(0xDD7DFF, MapColor.COLOR_PURPLE),
        PURPLE(8991416, MapColor.COLOR_PURPLE),
        INDIGO(4915330, MapColor.TERRACOTTA_PURPLE),
        WINE(7480675, MapColor.COLOR_PURPLE),
        LIGHT_BLUE(3847130, MapColor.COLOR_LIGHT_BLUE),
        ICY_BLUE(10404831, MapColor.TERRACOTTA_BLUE),
        SKY_BLUE(8900331, MapColor.COLOR_LIGHT_BLUE),
        CHERENKOV(104591, MapColor.COLOR_LIGHT_BLUE),
        CYAN(1481884, MapColor.COLOR_CYAN),
        ULTRAMARINE(5656703, MapColor.COLOR_BLUE),
        BLUE(3949738, MapColor.COLOR_BLUE),
        COBALT(18347, MapColor.COLOR_BLUE),
        NAVY(1845585, MapColor.TERRACOTTA_BLUE),
        AQUAMARINE(2916223, MapColor.TERRACOTTA_CYAN),
        TEAL(32896, MapColor.DIAMOND),
        TURQUOISE(4251856, MapColor.WARPED_STEM),
        MINT(0x89D898, MapColor.COLOR_GREEN),
        LIME(8439583, MapColor.COLOR_LIGHT_GREEN),
        SPRING_GREEN(12838793, MapColor.TERRACOTTA_LIGHT_GREEN),
        CHARTREUSE(0x7FFF00, MapColor.COLOR_LIGHT_GREEN),
        CONIFER(12236597, MapColor.TERRACOTTA_LIGHT_GREEN),
        GREEN(6192150, MapColor.COLOR_GREEN),
        EMERALD(5294200, MapColor.COLOR_GREEN),
        FOREST_GREEN(0x228B22, MapColor.TERRACOTTA_GREEN),
        OLIVE(5597999, MapColor.TERRACOTTA_GREEN),
        LIGHT_GRAY(0x9D9D97, MapColor.COLOR_LIGHT_GRAY),
        SILVER(0xC0C0C0, MapColor.COLOR_LIGHT_GRAY),
        GRAY(4673362, MapColor.COLOR_GRAY),
        BEIGE(16119260, MapColor.SAND),
        TAN(13808780, MapColor.TERRACOTTA_BROWN),
        BROWN(8606770, MapColor.COLOR_BROWN),
        BLACK(0x1D1D21, MapColor.COLOR_BLACK);

        public static final Codec<Colors> CODEC;
        public static final StreamCodec<ByteBuf, Colors> STREAM_CODEC;
        private static final String BASE = "crystalix_glass";
        private final int color;
        private final MapColor map;

        @Nullable
        public static Colors fromState(BlockState state) {
            String path = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getPath();
            if (!path.endsWith(BASE)) {
                return null;
            }
            if ((path = path.substring(0, path.length() - BASE.length())).endsWith("clear_")) {
                path = path.substring(0, path.length() - "clear_".length());
            } else if (path.endsWith("bordered_")) {
                path = path.substring(0, path.length() - "bordered_".length());
            }
            if (path.endsWith("_")) {
                path = path.substring(0, path.length() - "_".length());
            }
            if (path.isEmpty()) {
                return CLEAR;
            }
            for (Colors color : Colors.values()) {
                if (!color.getSerializedName().equals(path)) continue;
                return color;
            }
            log.warn("Unknown color: {}", (Object)path);
            return null;
        }

        @NotNull
        public String format(Types type) {
            String prefix = this.equals(CLEAR) ? "" : this.getSerializedName() + "_";
            String suffix = switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "";
                case 1 -> "clear_";
                case 2 -> "bordered_";
            };
            return prefix + suffix + BASE;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public MutableComponent text() {
            return Component.literal((String)this.translation()).withStyle(style -> style.withColor(this.color()));
        }

        @Override
        public MutableComponent text(Object ... args) {
            return Component.literal((String)this.translation()).withStyle(style -> style.withColor(this.color()));
        }

        @Override
        public String key() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public String translation() {
            return String.format("#%06X", this.color() & 0xFFFFFF);
        }

        @Generated
        private Colors(int color, MapColor map) {
            this.color = color;
            this.map = map;
        }

        @Generated
        public int color() {
            return this.color;
        }

        @Generated
        public MapColor map() {
            return this.map;
        }

        static {
            CODEC = EnumCodecs.makeCodec(Colors.class);
            STREAM_CODEC = EnumCodecs.makeStreamCodec(Colors.class);
        }
    }

    public static enum Types implements StringRepresentable
    {
        GLASS((TagKey<Item>)Tags.Items.GEMS_AMETHYST),
        CLEAR((TagKey<Item>)Tags.Items.GEMS_QUARTZ),
        BORDERED((TagKey<Item>)Tags.Items.INGOTS_IRON);

        private final TagKey<Item> tag;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Generated
        private Types(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Generated
        public TagKey<Item> tag() {
            return this.tag;
        }
    }
}

