/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.item;

import com.mojang.blaze3d.platform.InputConstants;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.common.properties.IProperty;
import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.annotations.NothingNull;
import dev.satherov.crystalix.util.BatchProcessor;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@NothingNull
public class CrystalixWand
extends Item {
    public CrystalixWand(Item.Properties properties) {
        super(properties.stacksTo(1).component(CSRegistry.INVISIBLE, (Object)false).component(CSRegistry.SHADELESS, (Object)false).component(CSRegistry.REINFORCED, (Object)false).component(CSRegistry.WATERLOGGABLE, (Object)false).component(CSRegistry.LIGHT, (Object)CSProperties.Light.NONE).component(CSRegistry.GHOST, (Object)CSProperties.Ghost.BLOCK_ALL).component(CSRegistry.COLOR, (Object)CSRegistry.Colors.CLEAR).component(CSRegistry.APPLY_COLORLESS, (Object)false));
    }

    public static ItemStack find(Player player) {
        if (player.getMainHandItem().getItem() instanceof CrystalixWand) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().getItem() instanceof CrystalixWand) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)CSLanguage.TOOLTIP_BULK.text(ChatFormatting.DARK_GRAY));
        components.add((Component)CSLanguage.TOOLTIP_COLORLESS.text(ChatFormatting.DARK_GRAY, ComponentUtils.wrapInSquareBrackets((Component)InputConstants.getKey((int)341, (int)-1).getDisplayName().copy().withStyle(ChatFormatting.GOLD))));
        components.add((Component)CSLanguage.PROPERTY_APPLY_COLORLESS.text(ChatFormatting.GRAY, (Boolean)stack.get(CSRegistry.APPLY_COLORLESS) != false ? CSLanguage.PROPERTY_ENABLED.text(ChatFormatting.DARK_GREEN) : CSLanguage.PROPERTY_DISABLED.text(ChatFormatting.DARK_RED)));
        for (IProperty<?> property : CSProperties.of(stack).properties().values()) {
            components.add((Component)property.text());
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.FAIL;
        }
        ServerLevel level2 = (ServerLevel)level;
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.FAIL;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos blockpos = context.getClickedPos();
        if (!this.applyToBlock(level2, blockpos, player2)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean applyToBlock(ServerLevel level, BlockPos pos, ServerPlayer player) {
        Block block = level.getBlockState(pos).getBlock();
        if (!(block instanceof CrystalixGlass)) {
            return false;
        }
        CrystalixGlass glass = (CrystalixGlass)block;
        ItemStack wand = CrystalixWand.find((Player)player);
        BlockState state = glass.fromStack((LevelAccessor)level, pos, wand);
        if (player.isShiftKeyDown()) {
            BatchProcessor.schedule(BatchProcessor.Batch.of(player, pos, state));
        } else {
            level.setBlock(pos, state, 3);
        }
        return true;
    }
}

