/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SLBlock
extends Block {
    private StateBuilder stateBuilder;

    public SLBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState(this.stateBuilder.defaultBlockState());
        this.stateBuilder.clear();
    }

    public static VoxelShape column(double size, double y1, double y2) {
        return SLBlock.column(size, size, y1, y2);
    }

    public static VoxelShape column(double xSize, double zSize, double y1, double y2) {
        double dx = xSize / 2.0;
        double dz = zSize / 2.0;
        return SLBlock.box((double)(8.0 - dx), (double)y1, (double)(8.0 - dz), (double)(8.0 + dx), (double)y2, (double)(8.0 + dz));
    }

    protected final void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        this.stateBuilder = StateBuilder.create(this);
        this.registerState(this.stateBuilder);
        this.stateBuilder.createDefinition(builder);
    }

    protected void registerState(StateBuilder builder) {
    }

    protected final void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!newState.is(state.getBlock())) {
            this.onRemoved((ServerLevel)level, pos, state, newState, movedByPiston);
            if (state.hasBlockEntity()) {
                level.removeBlockEntity(pos);
            }
        } else {
            this.onChanged((ServerLevel)level, pos, state, newState, movedByPiston);
        }
    }

    protected final void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!state.is(oldState.getBlock())) {
            this.onPlaced((ServerLevel)level, pos, state, oldState, movedByPiston);
        }
    }

    protected void onRemoved(ServerLevel level, BlockPos pos, BlockState state, BlockState newState, boolean movedByPiston) {
    }

    protected void onChanged(ServerLevel level, BlockPos pos, BlockState state, BlockState newState, boolean movedByPiston) {
    }

    protected void onPlaced(ServerLevel level, BlockPos pos, BlockState state, BlockState oldState, boolean movedByPiston) {
    }

    public static class StateBuilder {
        private final SLBlock block;
        private final Map<Property<?>, Comparable<?>> properties = new HashMap();

        private StateBuilder(SLBlock block) {
            this.block = block;
        }

        protected static <B extends SLBlock> StateBuilder create(B block) {
            return new StateBuilder(block);
        }

        private static <T extends Comparable<T>> BlockState setUnchecked(BlockState state, Property<?> property, Comparable<?> value) {
            return (BlockState)state.setValue(property, value);
        }

        public <T extends Comparable<T>, V extends T> StateBuilder addValue(Property<T> property, V defaultValue) {
            this.properties.put(property, (Comparable<?>)defaultValue);
            return this;
        }

        private void createDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            for (Property<?> property : this.properties.keySet()) {
                builder.add(new Property[]{property});
            }
        }

        private BlockState defaultBlockState() {
            BlockState state = this.block.defaultBlockState();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.properties.entrySet()) {
                state = StateBuilder.setUnchecked(state, entry.getKey(), entry.getValue());
            }
            return state;
        }

        private void clear() {
            this.properties.clear();
            this.block.stateBuilder = null;
        }
    }
}

