/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BlockPosBasePacket;
import com.supermartijn642.core.network.PacketContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class BlockEntityBasePacket<T extends BlockEntity>
extends BlockPosBasePacket {
    public ResourceKey<Level> dimension;

    public BlockEntityBasePacket() {
    }

    public BlockEntityBasePacket(ResourceKey<Level> dimension, BlockPos pos) {
        super(pos);
        this.dimension = dimension;
    }

    public BlockEntityBasePacket(Level world, BlockPos pos) {
        this((ResourceKey<Level>)(world == null ? null : world.dimension()), pos);
    }

    public BlockEntityBasePacket(BlockPos pos) {
        this((ResourceKey<Level>)((ResourceKey)null), pos);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.dimension != null);
        if (this.dimension != null) {
            buffer.writeResourceLocation(this.dimension.location());
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        super.read(buffer);
        if (buffer.readBoolean()) {
            this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
        }
    }

    @Override
    protected void handle(BlockPos pos, PacketContext context) {
        T tile = this.getTileEntity(context);
        if (tile != null) {
            this.handle(tile, context);
        }
    }

    protected abstract void handle(T var1, PacketContext var2);

    private T getTileEntity(PacketContext context) {
        Level world;
        Object object = this.dimension == null ? context.getWorld() : (context.getHandlingSide() == CoreSide.CLIENT ? (context.getWorld().dimension() == this.dimension ? context.getWorld() : null) : (world = context.getWorld().getServer().getLevel(this.dimension)));
        if (world == null) {
            return null;
        }
        BlockEntity tile = world.getBlockEntity(this.pos);
        if (tile == null) {
            return null;
        }
        try {
            return (T)tile;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

