/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class PackagePatternPrintingBehaviour
implements PrintingBehaviour {
    private final ItemStack pattern;
    private final SmartFluidTankBehaviour tank;

    public PackagePatternPrintingBehaviour(ItemStack pattern, SmartFluidTankBehaviour tank) {
        this.pattern = pattern;
        this.tank = tank;
    }

    public static Optional<DataResult<PrintingBehaviour>> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        String address;
        if (stack.getItem() instanceof PackageItem && ((address = (String)stack.get(AllDataComponents.PACKAGE_ADDRESS)) == null || address.isEmpty())) {
            return Optional.of(DataResult.success((Object)new PackagePatternPrintingBehaviour(stack.copy(), tank)));
        }
        return Optional.empty();
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        if (stack.getItem() instanceof PackageItem && !stack.is(this.pattern.getItem())) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        Integer amount = (Integer)fluidStack.getFluidHolder().getData(CEIDataMaps.PRINTING_PATTERN_INGREDIENT);
        return amount == null ? 0 : amount;
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        ItemStack result = stack.transmuteCopy((ItemLike)this.pattern.getItem());
        return result;
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        level.levelEvent(1043, pos.below(), 0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CEILang.translate("gui.goggles.printing.pattern", new Object[0]).forGoggles(tooltip);
        Integer amount = (Integer)this.tank.getPrimaryHandler().getFluid().getFluidHolder().getData(CEIDataMaps.PRINTING_PATTERN_INGREDIENT);
        if (amount != null) {
            CEILang.translate("gui.goggles.printing.cost", CEILang.number(amount.intValue()).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(amount <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).forGoggles(tooltip, 1);
        } else if (!this.tank.getPrimaryHandler().getFluid().isEmpty()) {
            CEILang.translate("gui.goggles.printing.incorrect_liquid", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        }
        return true;
    }
}

